/******************************************************************* vim: ft=c

 Copyright (c) 2001-2007  OpenSS7 Corporation <http://www.openss7.com>
 Copyright (c) 1997-2000  Brian F. G. Bidulock <bidulock@openss7.org>

 All Rights Reserved.

 This program is free software; you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation; version 2 of the License.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 details.

 You should have received a copy of the GNU General Public License along with
 this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 Ave, Cambridge, MA 02139, USA.

 -----------------------------------------------------------------------------

 U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software on
 behalf of the U.S. Government ("Government"), the following provisions apply
 to you.  If the Software is supplied by the Department of Defense ("DoD"), it
 is classified as "Commercial Computer Software" under paragraph 252.227-7014
 of the DoD Supplement to the Federal Acquisition Regulations ("DFARS") (or any
 successor regulations) and the Government is acquiring only the license rights
 granted herein (the license rights customarily provided to non-Government
 users).  If the Software is supplied to any unit or agency of the Government
 other than DoD, it is classified as "Restricted Computer Software" and the
 Government's rights in the Software are defined in paragraph 52.227-19 of the
 Federal Acquisition Regulations ("FAR") (or any successor regulations) or, in
 the cases of NASA, in paragraph 18.52.227-86 of the NASA Supplement to the FAR
 (or any successor regulations).

 -----------------------------------------------------------------------------

 Commercial licensing and support of this software is available from OpenSS7
 Corporation at a fee.  See http://www.openss7.com/

 *****************************************************************************/

/*
 * GENERATED BY strconf-sh (Sun Jun 24 15:50:14 MDT 2007) FROM Config.master
 * EDITS TO THIS FILE WILL BE LOST: EDIT strconf-sh INSTEAD.
 */

static char const ident[] = "$RCSfile$ $Name$($Revision$) $Date$";

#if defined(LINUX)
#	include <sys/types.h>
#	include <sys/stat.h>
#	include <sys/sysmacros.h>
#	define makedevice(maj,min) makedev(maj,min)
#elif defined(QNX)
#	include <sys/types.h>
#	include <sys/stat.h>
#	define makedevice(maj,min) makedev(1,maj,min)
#elif defined(USER)
#	include <sys/stropts.h>
#	include <sys/LiS/usrio.h>
#else
#	include <sys/types.h>
#	include <sys/stat.h>
#	define makedevice(maj,min) makedev(maj,min)
#endif
#ifdef _GNU_SOURCE
#       include <getopt.h>
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#if !defined(LINUX)
#	include <fcntl.h>
#endif

#if !defined(USER)
void copying(int argc, char *argv[])
{
	fprintf(stdout, "\n\
%1$s %2$s:\n\
\n\
Copyright (c) 2001-2007  OpenSS7 Corporation <http://www.openss7.com/>\n\
Copyright (c) 1997-2001  Brian F. G. Bidulock <bidulock@openss7.org>\n\
Copyright (c) 1997       David Grothe, Gcom, Inc <dave@gcom.com>\n\
\n\
All Rights Reserved.\n\
\n\
This program is free software;  you can  redistribute  it and/or modify it under\n\
the terms of the GNU General  Public License as  published by the  Free Software\n\
Foundation; version 2 of  the  License.\n\
\n\
This program is distributed in the hope that it will be  useful, but WITHOUT ANY\n\
WARRANTY;  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A\n\
PARTICULAR PURPOSE.  See the GNU General Public License for more details.\n\
\n\
You should  have received  a copy of the GNU  General  Public License along with\n\
this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,\n\
Cambridge, MA 02139, USA.\n\
\n\
U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software on behalf\n\
of the  U.S. Government  (\"Government\"),  the following provisions apply to you.\n\
If the Software is  supplied by the Department of Defense (\"DoD\"), it is classi-\n\
fied as  \"Commercial Computer Software\"  under paragraph 252.227-7014 of the DoD\n\
Supplement  to the  Federal Acquisition Regulations  (\"DFARS\") (or any successor\n\
regulations) and the  Government  is acquiring  only the license rights  granted\n\
herein (the license  rights customarily  provided to non-Government  users).  If\n\
the Software is supplied to any unit or agency of the Government other than DoD,\n\
it is classified as  \"Restricted Computer Software\" and the  Government's rights\n\
in the  Software are defined in  paragraph 52.227-19 of the Federal  Acquisition\n\
Regulations  (\"FAR\") (or any successor  regulations) or, in the  cases of NASA, in\n\
paragraph  18.52.227-86 of the  NASA Supplement  to the  FAR (or  any  successor\n\
regulations).\n\
\n\
", argv[0], ident);
}

void version(int argc, char *argv[])
{
	fprintf(stdout, "\
\n\
%1$s %2$s:\n\
    Copyright (c) 2003-2007  OpenSS7 Corporation.  All Rights Reserved.\n\
    Copyright (c) 1997       David Grothe, Gcom, Inc <dave@gcom.com>\n\
\n\
    Distributed by OpenSS7 Corporation under GPL Version 2,\n\
    included here by reference.\n\
\n\
    See `%1$s --copying' for copying permissions.\n\
\n\
", argv[0], ident);
}

void usage(int argc, char *argv[])
{
	fprintf(stderr, "\
Usage:\n\
    %1$s [options]\n\
    %1$s {-h,--help}\n\
    %1$s {-V,--version}\n\
    %1$s {-C,--copying}\n\
", argv[0]);
}

void help(int argc, char *argv[])
{
	fprintf(stdout, "\
\n\
Usage:\n\
    %1$s [options]\n\
    %1$s {-h,--help}\n\
    %1$s {-V,--version}\n\
    %1$s {-C,--copying}\n\
Options:\n\
    -r, --remove\n\
        remove devices before making them\n\
    -h, --help, -?\n\
        print this usage information and exit\n\
    -V, --version\n\
        print version and exit\n\
    -C, --copying\n\
        print copying permission and exit\n\
\n\
", argv[0]);
}
#endif				/* !defined(USER) */

int main(int argc, char *argv[])
{
	int rslt;
	int rmopt = 0;
	char *strerror(int);

        (void) rslt;
#if !defined(USER)
	(void) umask(0);
	if (argc == 2 && argv[1][0] == '-' && argv[1][1] == 'r')
		rmopt = 1;

	while (1) {
		int c;
#ifdef _GNU_SOURCE
		int option_index = 0;
		/* *INDENT-OFF* */
		static struct option long_options[] = {
			{ "help",    no_argument, NULL, 'h'},
			{ "version", no_argument, NULL, 'V'},
			{ "copying", no_argument, NULL, 'C'},
			{ "remove",  no_argument, NULL, 'r'},
			{ "?",       no_argument, NULL, 'h'},
			{ 0, }
		};
		/* *INDENT-ON* */
		c = getopt_long_only(argc, argv, "rhVC?", long_options, &option_index);
#else				/* _GNU_SOURCE */
		c = getopt(argc, argv, "rhVC?");
#endif				/* _GNU_SOURCE */
		if (c == -1)
			break;
		switch (c) {
		case 'r':	/* -r, --remove */
			rmopt = 1;
                        break;
		case 'h':	/* -h, --help */
			help(argc, argv);
			exit(0);
		case 'V':	/* -V, --version */
			version(argc, argv);
			exit(0);
		case 'C':	/* -C, --copying */
			copying(argc, argv);
			exit(0);
		case '?':
			optind--;
		      bad_nonoption:
			if (optind < argc) {
				fprintf(stderr, "%s: illegal syntax -- ", argv[0]);
				for (; optind < argc; optind++)
					fprintf(stderr, "%s ", argv[optind]);
				fprintf(stderr, "\n");
			}
			usage(argc, argv);
			exit(2);
		}
	}
	if (optind < argc)
		goto bad_nonoption;

#endif
	(void) ident;

/* -------------------------------------------------- */

#if !defined(USER)
	(void)unlink("/dev/clone");
#endif
	if (!rmopt) {
		rslt = mknod("/dev/clone", 020666, makedevice(230,0));
		if (rslt < 0)
			printf("/dev/clone: %s\n", strerror(-rslt));
	}
#if !defined(USER)
	(void)unlink("/dev/echo");
#endif
	if (!rmopt) {
		rslt = mknod("/dev/echo", 020666, makedevice(230,242));
		if (rslt < 0)
			printf("/dev/echo: %s\n", strerror(-rslt));
	}
#if !defined(USER)
	(void)unlink("/dev/fifo");
#endif
	if (!rmopt) {
		rslt = mknod("/dev/fifo", 020666, makedevice(243,0));
		if (rslt < 0)
			printf("/dev/fifo: %s\n", strerror(-rslt));
	}
#if !defined(USER)
	(void)unlink("/dev/strlog");
#endif
	if (!rmopt) {
		rslt = mknod("/dev/strlog", 020666, makedevice(230,244));
		if (rslt < 0)
			printf("/dev/strlog: %s\n", strerror(-rslt));
	}
#if !defined(USER)
	(void)unlink("/dev/conslog");
#endif
	if (!rmopt) {
		rslt = mknod("/dev/conslog", 020666, makedevice(244,1));
		if (rslt < 0)
			printf("/dev/conslog: %s\n", strerror(-rslt));
	}
#if !defined(USER)
	(void)unlink("/dev/loop.1");
#endif
	if (!rmopt) {
		rslt = mknod("/dev/loop.1", 020644, makedevice(245,1));
		if (rslt < 0)
			printf("/dev/loop.1: %s\n", strerror(-rslt));
	}
#if !defined(USER)
	(void)unlink("/dev/loop.2");
#endif
	if (!rmopt) {
		rslt = mknod("/dev/loop.2", 020666, makedevice(245,2));
		if (rslt < 0)
			printf("/dev/loop.2: %s\n", strerror(-rslt));
	}
#if !defined(USER)
	(void)unlink("/dev/loop_clone");
#endif
	if (!rmopt) {
		rslt = mknod("/dev/loop_clone", 020666, makedevice(230,245));
		if (rslt < 0)
			printf("/dev/loop_clone: %s\n", strerror(-rslt));
	}
#if !defined(USER)
	(void)unlink("/dev/sloop");
#endif
	if (!rmopt) {
		rslt = mknod("/dev/sloop", 020666, makedevice(230,245));
		if (rslt < 0)
			printf("/dev/sloop: %s\n", strerror(-rslt));
	}
#if !defined(USER)
	(void)unlink("/dev/nsdev");
#endif
	if (!rmopt) {
		rslt = mknod("/dev/nsdev", 020666, makedevice(246,0));
		if (rslt < 0)
			printf("/dev/nsdev: %s\n", strerror(-rslt));
	}
#if !defined(USER)
	(void)unlink("/dev/nuls");
#endif
	if (!rmopt) {
		rslt = mknod("/dev/nuls", 020666, makedevice(230,247));
		if (rslt < 0)
			printf("/dev/nuls: %s\n", strerror(-rslt));
	}
#if !defined(USER)
	(void)unlink("/dev/pipe");
#endif
	if (!rmopt) {
		rslt = mknod("/dev/pipe", 020666, makedevice(248,0));
		if (rslt < 0)
			printf("/dev/pipe: %s\n", strerror(-rslt));
	}
#if !defined(USER)
	(void)unlink("/dev/sad");
#endif
	if (!rmopt) {
		rslt = mknod("/dev/sad", 020666, makedevice(230,249));
		if (rslt < 0)
			printf("/dev/sad: %s\n", strerror(-rslt));
	}
#if !defined(USER)
	(void)unlink("/dev/sfx");
#endif
	if (!rmopt) {
		rslt = mknod("/dev/sfx", 020666, makedevice(250,0));
		if (rslt < 0)
			printf("/dev/sfx: %s\n", strerror(-rslt));
	}
#if !defined(USER)
	(void)unlink("/dev/spx");
#endif
	if (!rmopt) {
		rslt = mknod("/dev/spx", 020666, makedevice(251,0));
		if (rslt < 0)
			printf("/dev/spx: %s\n", strerror(-rslt));
	}

/* -------------------------------------------------- */

#if !defined(USER)
	exit(0);
#else
	return (0);
#endif
}

/* 
 * vim: ft=c
 */
