'\" rtp
.\" -*- nroff -*- vim: ft=nroff nocin nosi
.\"
.\" @(#) strsetup.8.man,v 0.9.2.19 2006/04/05 09:44:41 brian Exp
.\"
.\" =========================================================================
.\"
.\" Copyright (c) 2001-2006  OpenSS7 Corporation <http://www.openss7.com/>
.\"
.\" All Rights Reserved.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a
.\" permission notice identical to this one
.\" 
.\" Since the Linux kernel and libraries are constantly changing, this
.\" manual page may be incorrect or out-of-date.  The author(s) assume no
.\" responsibility for errors or omissions, or for damages resulting from
.\" the use of the information contained herein.  The author(s) may not
.\" have taken the same level of care in the production of this manual,
.\" which is licensed free of charge, as they might when working
.\" professionally.  The author(s) will take no responsibility in it.
.\" 
.\" Formatted or processed versions of this manual, if unaccompanied by
.\" the source, must acknowledge the copyright and authors of this work.
.\"
.\" -------------------------------------------------------------------------
.\"
.\" U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software
.\" on behalf of the U.S. Government ("Government"), the following
.\" provisions apply to you.  If the Software is supplied by the Department
.\" of Defense ("DoD"), it is classified as "Commercial Computer Software"
.\" under paragraph 252.227-7014 of the DoD Supplement to the Federal
.\" Acquisition Regulations ("DFARS") (or any successor regulations) and the
.\" Government is acquiring only the license rights granted herein (the
.\" license rights customarily provided to non-Government users).  If the
.\" Software is supplied to any unit or agency of the Government other than
.\" DoD, it is classified as "Restricted Computer Software" and the
.\" Government's rights in the Software are defined in paragraph 52.227-19
.\" of the Federal Acquisition Regulations ("FAR") (or any successor
.\" regulations) or, in the cases of NASA, in paragraph 18.52.227-86 of the
.\" NASA Supplement to the FAR (or any successor regulations).
.\"
.\" =========================================================================
.\" 
.\" Commercial licensing and support of this software is available from
.\" OpenSS7 Corporation at a fee.  See http://www.openss7.com/
.\" 
.\" =========================================================================
.\"
.\" Last Modified 2006/04/05 09:44:41 by brian
.\"
.\" -------------------------------------------------------------------------
.\"
.\" strsetup.8.man,v
.\" Revision 0.9.2.19  2006/04/05 09:44:41  brian
.\" - moved .so line and updated headers
.\"
.\" =========================================================================
.R1
bracket-label "\fR[\fB" "\fR]" "\fR, \fB"
no-default-database
database strutil.refs
accumulate
move-punctuation
abbreviate A
join-authors ", " ", " " and "
et-al " et al" 2 3
abbreviate-label-ranges ".."
sort-adjacent-labels
.R2
.so strutil.macros
.\"
.\"
.TH STRSETUP 8 "@PACKAGE_DATE@" "@PACKAGE@-@VERSION@" "@PACKAGE_TITLE@ Administration"
.\"
.\"
.SH NAME
.B strsetup
\- \fISTREAMS\fP setup command
.\"
.\"
.SH SYNOPSIS
.PP
.HP 12
\fBstrsetup\fR [\fIoptions\fR] {\fB-c\fR|\fB--config\fR}
.PD 0
.HP 12
\fBstrsetup\fR [\fIoptions\fR] {\fB-i\fR|\fB--install\fR}
.HP 12
\fBstrsetup\fR [\fIoptions\fR] {\fB-f\fR|\fB--filename\fR} \fIFILENAME\fR
.HP 12
\fBstrsetup\fR [\fIoptions\fR] {\fB-d\fR|\fB--delete\fR}
.HP 12
\fBstrsetup\fR {\fB-h\fR|\fB--help\fR}
.HP 12
\fBstrsetup\fR {\fB-V\fR|\fB--version\fR}
.HP 12
\fBstrsetup\fR {\fB-C\fR|\fB--copying\fR}
.PD
.\"
.\"
.SH DESCRIPTION
.PP
.B strsetup
displays the
.I STREAMS
setup of modules and drivers or creates the appropriate character special
files for
.IR STREAMS -based
drivers.
.\"
.\"
.SH OPTIONS
.PP
.TP
.BI "-c, --config"
Lists the current kernel configuration of
.I STREAMS
modules and drivers.  This option does not require privilege.
.TP
.BI "-d, --delete"
Deletes all of the
.B /dev
entries that correspond to
.I STREAMS
drivers.
.TP
.BI "-f, --filename " filename
Uses a files to create
.B /dev
entries for
.I STREAMS
devices.  (See
.IR "\*(lqFILE FORMAT\*(rq" ,
below.)
.TP
.BI "-i, --install"
Creates entries in
.B /dev
appropriate for the current kernel configuration.
By default, this uses the configuration file
.BR /etc/sysconf/streams/strsetup.conf .
If no file exists or is specified, only clone devices will be created.
.TP
\fB-q\fR, \fB--quiet\fR
Suppresses normal output.
.TP
\fB-D\fR, \fB--debug\fR [\fILEVEL\fr]
Increase or specify the debug output
.IR LEVEL .
When a debug
.I LEVEL
has been specified,
.B strerr
will log to
.BR stdout ,
prints debug messages to
.BR stderr ,
and will not place itself in the background.
.TP
\fB-v\fR, \fB--verbose\fR [\fILEVEL\fR]
Increase or specify the verbosity
.I LEVEL
of the output.  This option may be repeated.
.TP
\fB-h\fR, \fB--help\fR
When this options is encountered,
.B strsetup
displays usage information on
.I stdout
and exits.
.TP
\fB-V\fR, \fB--version\fR
When this option is encountered,
.B strsetup
displays versions information on
.I stdout
and exits.
.TP
\fB-C\fR, \fB--copying\fR
When this option is encountered,
.B strsetup
displays copying and copyright information on
.I stdout
and exits.
.\"
.\"
.SH "FILE FORMAT"
.PP
Each line in the configuration file is of the format:
.RB < driver_name "> <" filename "> <" file_mode "> <" minor_number >.
.TP
.RB < driver_name >
Specifies the name of the driver as reported by the
.B strsetup -c
command.  This field is used to match the names read by the
.B strsetup
command from the kernel and must match exactly (the match is case sensitive).
.TP
.RB < filename >
Specifies the full path name of the character special file or files to be
created when
.B driver_name
is configured into the kernel.  The
.I filename
can contain one conversion specifier in the style of
.BR printf (3).
This conversion specifier is used to include a minor device number in the
filename.  The permitted conversions are the following:
.RS
.IP \fB%d\fR
Prints the minor number as a signed decimal.
.PD 0
.IP \fB%x\fR
Prints the minor number as hexadecimal with lower case letters.
.IP \fB%X\fR
Prints the minor number as hexadecimal with upper case letters.
.IP \fB%o\fR
Prints the minor number as octal.
.IP \fB%u\fR
Prints the minor number as an unsigned decimal.
.IP \fB%i\fR
Prints the minor number as a signed decimal.
.PD
.PP
Note that you must use a double percent sign (%%) to include a percent sign in
the filename.  Optionally, each of these conversions can include a
specification for some number of leading 0's.  This is done by following %
with a 0 and one or more digits specifying the total number of digits to be
printed.  The 0 must appear after the %.  See
.BR printf (3)
for more information.  Any directories in the path of the filename that do not
exist are created.
.RE
.TP
.RB < file_mode >
Specifies the file mode assigned to the file when it is created.  The
.I file_mode
field must be in octal.
.TP
.RB < minor_number >
Specifies the minor device number field.  The
.B strsetup
command reads the major device numbers from the kernel.  This field indicates
to the
.B strsetup
command how to assign minor device numbers.  The
.I minor_number
field can contain one of the following values:
.RS
.TP
.B clone
Indicates that the device should be created as a clone device.  In this case
the major number becomes that of the special
.BR clone (4)
pseudo-device driver and the minor device number becomes the device's major
number.  Note that the word \(lqclone\(rq must be lower case.
.TP
.B N
Creates a single device with the minor device number
.IR N .
Note that
.I N
is a decimal number.
.TP
.B M-N
Creates
.IR M - N
nodes with the devices' major numbers and minor numbers between
.IR M " and " N .
Note that
.IR M " and " N
are decimal numbers.  When a range of minor numbers is specified, a filename
conversion specifier can be used to make certain that each node created is
unique.
.RE
.\"
.\"
.SH DIAGNOSTICS
.PP
An exit status of zero (0) indicates that the command was successful; one (1)
indicates that an error occurred and a diagnostic message is printed to
.BR stderr ;
two (2) indicates that the option syntax was in error and a diagnostic message
is printed to
.BR stderr .
.PP
Errors can result from inadequate permissions, inability to open the
.BR nuls (4)
driver, inability to push the
.BR sc (4)
module.
.\"
.\"
.SH NOTICES
.PP
.B strsetup -i
should be run by the system at boot time.  This creates the device special
files for any new
.I STREAMS
modules.
.PP
The
.B strsetup
command requires that the
.BR sc (4)
.I STREAMS
module and the
.BR nuls (4)
.I STREAMS
driver.  It either one is not available, the
.B strsetup
command will not be successful.
.\"
.\"
.SH EXAMPLES
.PP
An example
.B strsetup
configuration file for use with the command
.BI "strsetup -f " filename
is as follows:
.RS
.nf
\fC\s-2
#
# strsetup - sample configuration file
#

# driver name   filename                file mode       minor number

ptm             /dev/ptmx               0666            clone
log             /dev/streams/log        0666            clone
nuls            /dev/streams/nuls       0666            clone
echo            /dev/streams/echo       0666            clone
sad             /dev/sad/admin          0666            clone
pts             /dev/pts/%d             0666            0-127
\s+2\fP
.fi
.RE
.PP
The following is sample output from the
.B strsetup
command:
.RS
.nf
\fC\s-2
#> /usr/sbin/strsetup -c

STREAMS Configuration Information...Fri Nov  3 14:23:36 1995

           Name       Type   Major  Module ID
           ----       ----   -----  ---------
          clone     device      32          0
            dlb     device      52       5010
          kinfo     device      53       5020
            log     device      54         44
           nuls     device      55       5001
           echo     device      56       5000
            sad     device      57         45
           pipe     device      58       5304
       xtisoUDP     device      59       5010
       xtisoTCP     device      60       5010
      xtisoUDP+     device      61       5010
      xtisoTCP+     device      62       5010
            ptm     device      63       7609
            pts     device       6       7608
            bba     device      64      24880
            lat     device       5          5
          pppif     module               6002
       pppasync     module               6000
        pppcomp     module               6001
        bufcall     module                  0
           null     module               5002
           pass     module               5003
           errm     module               5003
           ptem     module               5003
          spass     module               5007
         rspass     module               5008
        pipemod     module               5303
          timod     module               5006
         tirdwr     module                  0
          ldtty     module               7701
          ifnet     module               5501

        Configured devices = 15, modules = 15
\s+2\fP
.fi
.RE
.\"
.\"
.SH DEVICES
.PP
.TP
.B /dev/streams/*
the default pseudo-device creation directory.
.\"
.\"
.SH FILES
.PP
.TP
.B /usr/sbin/strsetup
contains the
.B strsetup
command.
.TP
.BR /etc/sysconf/streams/strsetup.conf
the default configuration file.
.\"
.\"
.SH "SEE ALSO"
.PP
.BR strsetup.conf (5),
.BR scls (8),
.BR strload (8),
.BR sc (4).
.\"
.\"
.SH BUGS
.PP
.B strsetup
has no known bugs.
.\"
.\"
.SH COMPATIBILITY
.PP
.B strsetup
is an
.IR OSF/1 \(rg-specific function.
.I @PACKAGE_TITLE@
provides
.B strsetup
for compatibility with
.IR OSF/1 \(rg
with the following portability considerations:
.IP \(em \w'\(em\(em'u
.IR OSF/1 \(rg
does not document long options.
.IP \(em
.IR OSF/1 \(rg
does not document the
.BR -q ", " -v ", " -h ", " -V " or " -C
options.
.IP \(em
Options
.BR --help " and " --version
are provided for compatibility with GNU coding standards;
.BR --copying ,
OpenSS7 coding standards.
.IP \(em
The format of the output from the
.B strsetup
command with the
.B -c
option may be different from that of
.IR OSF/1 \(rg.
.IP \(em
The default location for this file might differ under
.IR OSF/1 \(rg.
.\"
.\"
.SH CONFORMANCE
.PP
.IR OSF/1 \(rg
documentation.
.[
osfdoc
.]
.\"
.\"
.SH HISTORY
.PP
.B strsetup
first appeared in
.IR OSF/1 \(rg.
.\"
.\"
.[
$LIST$
.]
.TI
