'\" rtp
.\" -*- nroff -*- vim: ft=nroff nocin nosi
.\"
.\" @(#) strinfo.8.man,v 0.9.2.16 2006/04/05 09:44:41 brian Exp
.\"
.\" =========================================================================
.\"
.\" Copyright (c) 2001-2006  OpenSS7 Corporation <http://www.openss7.com/>
.\"
.\" All Rights Reserved.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a
.\" permission notice identical to this one
.\" 
.\" Since the Linux kernel and libraries are constantly changing, this
.\" manual page may be incorrect or out-of-date.  The author(s) assume no
.\" responsibility for errors or omissions, or for damages resulting from
.\" the use of the information contained herein.  The author(s) may not
.\" have taken the same level of care in the production of this manual,
.\" which is licensed free of charge, as they might when working
.\" professionally.  The author(s) will take no responsibility in it.
.\" 
.\" Formatted or processed versions of this manual, if unaccompanied by
.\" the source, must acknowledge the copyright and authors of this work.
.\"
.\" -------------------------------------------------------------------------
.\"
.\" U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software
.\" on behalf of the U.S. Government ("Government"), the following
.\" provisions apply to you.  If the Software is supplied by the Department
.\" of Defense ("DoD"), it is classified as "Commercial Computer Software"
.\" under paragraph 252.227-7014 of the DoD Supplement to the Federal
.\" Acquisition Regulations ("DFARS") (or any successor regulations) and the
.\" Government is acquiring only the license rights granted herein (the
.\" license rights customarily provided to non-Government users).  If the
.\" Software is supplied to any unit or agency of the Government other than
.\" DoD, it is classified as "Restricted Computer Software" and the
.\" Government's rights in the Software are defined in paragraph 52.227-19
.\" of the Federal Acquisition Regulations ("FAR") (or any successor
.\" regulations) or, in the cases of NASA, in paragraph 18.52.227-86 of the
.\" NASA Supplement to the FAR (or any successor regulations).
.\"
.\" =========================================================================
.\" 
.\" Commercial licensing and support of this software is available from
.\" OpenSS7 Corporation at a fee.  See http://www.openss7.com/
.\" 
.\" =========================================================================
.\"
.\" Last Modified 2006/04/05 09:44:41 by brian
.\"
.\" -------------------------------------------------------------------------
.\"
.\" strinfo.8.man,v
.\" Revision 0.9.2.16  2006/04/05 09:44:41  brian
.\" - moved .so line and updated headers
.\"
.\" =========================================================================
.R1
bracket-label "\fR[\fB" "\fR]" "\fR, \fB"
no-default-database
database strutil.refs
accumulate
move-punctuation
abbreviate A
join-authors ", " ", " " and "
et-al " et al" 2 3
abbreviate-label-ranges ".."
sort-adjacent-labels
.R2
.so strutil.macros
.\"
.\"
.TH STRINFO 8 "@PACKAGE_DATE@" "@PACKAGE@-@VERSION@" "@PACKAGE_TITLE@ Administration"
.\"
.\"
.SH NAME
.B strinfo
\- display information about \fISTREAMS\fR devices
.\"
.\"
.SH SYNOPSIS
.PP
.HP 12
\fBstrinfo \fR{\fB-m\fR|\fB-q\fR}\fP
.PD 0
.HP 12
\fBstrinfo\fR {\fB-H\fR|\fB--help\fR}
.HP 12
\fBstrinfo\fR {\fB-V\fR|\fB--version\fR}
.HP 12
\fBstrinfo\fR {\fB-C\fR|\fB--copying\fR}
.PD
.\"
.\"
.SH DESCRIPTION
.PP
The
.B strinfo
command displays information for debugging purposes about
.I STREAMS
drivers and modules, or stream heads and the
.I STREAMS
run queue.
.\"
.\"
.SH OPTIONS
.PP
.TP
.BR -m ", " --modules
Print information about the
.I STREAMS
drivers and modules loaded on the system.
.TP
.BR -q ", " --queues
Print information about the
.I STREAMS
active stream heads and on the run queues upon which 
drivers and modules are
scheduled.
.TP
.BR -Q ", " --quiet
Suppresses normal output.
.TP
.BR -v ", " --verbose " [" \fIlevel\fR ]
Increases or specifies the verbosity level of the output.  This option may be
repeated.
.TP
.BR -H ", " --help
When this option is encountered,
.B strinfo
displays usage information on
.I stdout
and exists.
.TP
.BR -V ", " --version
When this option is encountered,
.B strinfo
displays version information on
.I stdout
and exists.
.TP
.BR -C ", " --copying
When this option is encountered,
.B strinfo
displays copying and copyright information on
.I stdout
and exists.
.PP
Only one of
.BR -m " or " -q
can be specified.  If no option is specified,
.B -m
is assumed.
.\"
.\"
.SH DIAGNOSTICS
.PP
.B strinfo
normally shows the requested result and returns an exit status of (0).  When
.B strinfo
fails, it returns a non-zero exit status and displays a diagnostic on
.IR stderr .
.\"
.\"
.SH NOTICES
.PP
.\"
.\"
.SH EXAMPLES
.PP
Example output of
.B strinfo -m
.RS
.nf
\fC\s-1
Device: 'sad', dcookie 0xf, flags:0x4, str 0x19a69e8
Device: 'slog', dcookie 0x10, flags:0x4, str 0x19a6c18
Device: 'rs', dcookie 0x11, flags:0x4, str 0x19bcb00
Module: 'bufcall', flags:0x1, str 0x19a5c00
Module: 'ldterm', flags:0x0, str 0x19cc858
\s+1\fP
.fi
.RE
.PP
Example output of
.B strinfo -q
.RS
.nf
\fC\s-1
Active Stream Heads
sth      sth_dev  sth_rq   sth_wq   sth_flag rq->q_first
05a7ee00 00110001 05ad7000 05ad7074 00000818 00000000

STREAMS Service Queue
Queue 0x5ad7000 Flags 0x10
\s+1\fP
.fi
.RE
.\"
.\"
.SH DEVICES
.PP
.\"
.\"
.SH FILES
.PP
.TP
.B /usr/sbin/strinfo
contains the
.B strinfo
command.
.\"
.\"
.SH "SEE ALSO"
.PP
.\"
.\"
.SH BUGS
.PP
.\"
.\"
.SH COMPATIBILITY
.PP
.B strinfo
is an
.IR AIX \(rg-specific
command.
.B strinfo
is provided for compatibility with
.IR AIX \(rg
with the following portability considerations:
.I @PACKAGE_TITLE@
provides
.B strinfo
for compatibility with
.IR AIX \(rg.
.IP \(bu
.IR AIX \(rg
does not document long options.
.IP \(em
Options
.BR --help " and " --version
are provided for compatibility with GNU coding standards;
.BR --copying ,
OpenSS7 coding standards.
.\"
.\"
.SH CONFORMANCE
.PP
.IR AIX \(rg
documentation.
.\"
.\"
.SH HISTORY
.PP
.B strinfo
first appeared in
.IR AIX \(rg.
.\"
.\"
.[
$LIST$
.]
.TI
