'\" rtp
.\" -*- nroff -*- vim: ft=nroff nocin nosi
.\"
.\" @(#) strclean.8.man,v 0.9.2.16 2006/04/05 09:44:41 brian Exp
.\"
.\" =========================================================================
.\"
.\" Copyright (c) 2001-2006  OpenSS7 Corporation <http://www.openss7.com/>
.\"
.\" All Rights Reserved.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a
.\" permission notice identical to this one
.\" 
.\" Since the Linux kernel and libraries are constantly changing, this
.\" manual page may be incorrect or out-of-date.  The author(s) assume no
.\" responsibility for errors or omissions, or for damages resulting from
.\" the use of the information contained herein.  The author(s) may not
.\" have taken the same level of care in the production of this manual,
.\" which is licensed free of charge, as they might when working
.\" professionally.  The author(s) will take no responsibility in it.
.\" 
.\" Formatted or processed versions of this manual, if unaccompanied by
.\" the source, must acknowledge the copyright and authors of this work.
.\"
.\" -------------------------------------------------------------------------
.\"
.\" U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software
.\" on behalf of the U.S. Government ("Government"), the following
.\" provisions apply to you.  If the Software is supplied by the Department
.\" of Defense ("DoD"), it is classified as "Commercial Computer Software"
.\" under paragraph 252.227-7014 of the DoD Supplement to the Federal
.\" Acquisition Regulations ("DFARS") (or any successor regulations) and the
.\" Government is acquiring only the license rights granted herein (the
.\" license rights customarily provided to non-Government users).  If the
.\" Software is supplied to any unit or agency of the Government other than
.\" DoD, it is classified as "Restricted Computer Software" and the
.\" Government's rights in the Software are defined in paragraph 52.227-19
.\" of the Federal Acquisition Regulations ("FAR") (or any successor
.\" regulations) or, in the cases of NASA, in paragraph 18.52.227-86 of the
.\" NASA Supplement to the FAR (or any successor regulations).
.\"
.\" =========================================================================
.\" 
.\" Commercial licensing and support of this software is available from
.\" OpenSS7 Corporation at a fee.  See http://www.openss7.com/
.\" 
.\" =========================================================================
.\"
.\" Last Modified 2006/04/05 09:44:41 by brian
.\"
.\" -------------------------------------------------------------------------
.\"
.\" strclean.8.man,v
.\" Revision 0.9.2.16  2006/04/05 09:44:41  brian
.\" - moved .so line and updated headers
.\"
.\" =========================================================================
.R1
bracket-label "\fR[\fB" "\fR]" "\fR, \fB"
no-default-database
database strutil.refs
accumulate
move-punctuation
abbreviate A
join-authors ", " ", " " and "
et-al " et al" 2 3
abbreviate-label-ranges ".."
sort-adjacent-labels
.R2
.so strutil.macros
.\"
.\"
.TH STRCLEAN 8 "@PACKAGE_DATE@" "@PACKAGE@-@VERSION@" "@PACKAGE_TITLE@ Administration"
.\"
.\"
.SH NAME
.B strclean
\- cleans up the \fISTREAMS\fR error logger
.\"
.\"
.SH SYNOPSIS
.PP
.HP 12
\fBstrclean\fR [{\fB-d\fR|\fB--directory\fR[=]}\fIDIRECTORY\fR] [{\fB-a\fR|\fB--age\fR[=]}\fR\fIAGE\fR]
.PD 0
.HP 12
\fBstrclean\fR {\fB-h\fR|\fB--help\fR}
.HP 12
\fBstrclean\fR {\fB-V\fR|\fB--version\fR}
.HP 12
\fBstrclean\fR {\fB-C\fR|\fB--copying\fR}
.PD
.\"
.\"
.SH OPTIONS
.PP
The following options can be used with the
.B strclean
command:
.TP
\fB-a\fR, \fB--age\fR \fIAGE\fR
Specifies the maximum age, in days, other than three (3), for a log file.
If not specified,
.I AGE
defaults to three (3).
.TP
\fB-b\fR, \fB--basename\fR \fIBASENAME\fR
file basename.  The default is
.RB ' errors '.
.TP
\fB-d\fR, \fB--directory\fR \fIDIRECTORY\fR
Specifies a directory other than
.BR /var/log/streams .
.\".BR /var/adm/streams .
If not specified,
.I DIRECTORY
defaults to
.BR /var/log/streams .
.\".BR /var/adm/streams .
.TP
\fB-o\fR, \fB--outfile\fR \fIOUTFILE\fR
removes files matching
.IR OUTFILE .
The default file match is
.RB ' errors.[0-1][0-9]-[0-3][0-9] '.
.TP
\fB-e\fR, \fB--errfile\fR \fIERRFILE\fR
removes files matching
.IR ERRFILE .
The default file match is
.RB ' errors.errors '.
.TP
\fB-q\fR, \fB--quiet\fR
Suppresses normal output.
.TP
\fB-D\fR, \fB--debug\fR [\fILEVEL\fr]
Increase or specify the debug output
.IR LEVEL .
When a debug
.I LEVEL
has been specified,
.B strerr
will log to
.BR stdout ,
prints debug messages to
.BR stderr ,
and will not place itself in the background.
.TP
\fB-v\fR, \fB--verbose\fR [\fILEVEL\fR]
Increase or specify the verbosity
.I LEVEL
of the output.  This option may be repeated.
.PP
The following options are general command options.  When one of these options is encountered, the
requested information is displayed and
.B strclean
exits without processing further options or arguments and without performing any other actions.
.TP
\fB-h\fR, \fB--help\fR
When this options is encountered,
.B strclean
displays usage information on
.I stdout
and exits.
.TP
\fB-V\fR, \fB--version\fR
When this option is encountered,
.B strclean
displays versions information on
.I stdout
and exits.
.TP
\fB-C\fR, \fB--copying\fR
When this option is encountered,
.B strclean
displays copying and copyright information on
.I stdout
and exits.
.\"
.\"
.SH DESCRIPTION
.PP
The
.B strclean
command is used to clean up the
.I STREAMS
error-logger directory on a regular basis: for example, by using the
.BR cron (8)
daemon.  By default, all files with names matching
.BI error.mm-dd
in the
.B /var/log/streams
.\".B /var/adm/streams
directory that have not been modified in the last three days are removed.
.\"
.\"
.SH DIAGNOSTICS
.PP
An exit status of zero (0) indicates that the command was successful; one (1)
indicates that an error occurred and a diagnostic message is printed on
.BR stderr ;
two (2) indicates that the option syntax was in error and a diagnostic message
is printed on
.BR stderr .
.PP
The
.B --quiet
option suppresses the printing of diagnostic messages to
.BR stderr .
.\"
.\"
.SH USAGE
.PP
The
.B strclean
command is typically run using the
.BR cron (8)
daemon on a daily or weekly basis.
.\"
.\"
.SH NOTICES
.PP
.B strclean
could easily be implemented as a script (and is).
.\"
.\"
.\".SH EXAMPLES
.\".PP
.\"
.\"
.SH DEVICES
.PP
.TP
.BR /dev/strlog ", " /dev/streams/log " or " /dev/log
the
.I STREAMS
logging device.
.\"
.\"
.SH FILES
.PP
.TP
.B /usr/sbin/strclean
contains the
.B strclean
command.
.TP
.BR /var/log/streams " or " /var/adm/streams
directory containing the error log files.
.TP
.BI /var/log/streams/error. "mm-dd \fR or " /var/adm/streams/error. mm-dd
contains the
.I STREAMS
error log.
.\"
.SH "SEE ALSO"
.PP
.BR cron (8),
.BR log (4),
.BR strlog (4),
.BR strlog (9),
.BR strerr (8),
.BR strace (8).
.\"
.\"
.SH BUGS
.PP
.B strclean
has no known bugs.
.\"
.\"
.SH COMPATIBILITY
.PP
.B strclean
is compatible with
.IR "SVR 4.2" ,
and systems based on
.IR "SVR 4.2" ,
such as
.IR AIX \(rg,
.IR HP-UX \(rg,
.IR OSF/1 \(rg,
.IR Solaris \(rg,
.IR UnixWare \(rg
and
.IR UXP/V \(rg,
with the following portability considerations:
.IP \(em \w'\(em\(em'u
No other implementation documents the
.BR -q ", " -d ", " -v ", " -h ", " -V " or " -C
options.
They should not be used by portable applications.
.IP \(em
Options
.BR --help " and " --version
are provided for compatibility with GNU coding standards;
.BR --copying ,
OpenSS7 coding standards.
.IP \(em
Under
.I @PACKAGE_TITLE@
.B strclean
will also clean out trace files left in the log directory and which are older
than
.IR AGE .
See
.BR strace (8)
for more information on trace log files.
.\"
.\"
.SH CONFORMANCE
.PP
.IR "SVR 4.2" ;
.[
svr42cr
.]
.IR AIX \(rg,
.IR HP-UX \(rg,
.IR OSF/1 \(rg,
.IR Solaris \(rg,
.IR UnixWare \(rg
and
.IR UXP/V \(rg
documentation.
.[
aixdoc
.]
.[
hpuxdoc
.]
.[
osfdoc
.]
.[
soldoc
.]
.[
uw7doc
.]
.[
uxpdoc
.]
.\"
.\"
.SH HISTORY
.PP
.PP
.B strclean
first appeared in
.IR "SVR 4" .
.[
svr4
.]
.\"
.\"
.[
$LIST$
.]
.TI
