'\" rtp
.\" -*- nroff -*- vim: ft=nroff nocin nosi
.\"
.\" @(#) strace.8.man,v 0.9.2.16 2006/04/05 09:44:41 brian Exp
.\"
.\" =========================================================================
.\"
.\" Copyright (c) 2001-2006  OpenSS7 Corporation <http://www.openss7.com/>
.\"
.\" All Rights Reserved.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a
.\" permission notice identical to this one
.\" 
.\" Since the Linux kernel and libraries are constantly changing, this
.\" manual page may be incorrect or out-of-date.  The author(s) assume no
.\" responsibility for errors or omissions, or for damages resulting from
.\" the use of the information contained herein.  The author(s) may not
.\" have taken the same level of care in the production of this manual,
.\" which is licensed free of charge, as they might when working
.\" professionally.  The author(s) will take no responsibility in it.
.\" 
.\" Formatted or processed versions of this manual, if unaccompanied by
.\" the source, must acknowledge the copyright and authors of this work.
.\"
.\" -------------------------------------------------------------------------
.\"
.\" U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software
.\" on behalf of the U.S. Government ("Government"), the following
.\" provisions apply to you.  If the Software is supplied by the Department
.\" of Defense ("DoD"), it is classified as "Commercial Computer Software"
.\" under paragraph 252.227-7014 of the DoD Supplement to the Federal
.\" Acquisition Regulations ("DFARS") (or any successor regulations) and the
.\" Government is acquiring only the license rights granted herein (the
.\" license rights customarily provided to non-Government users).  If the
.\" Software is supplied to any unit or agency of the Government other than
.\" DoD, it is classified as "Restricted Computer Software" and the
.\" Government's rights in the Software are defined in paragraph 52.227-19
.\" of the Federal Acquisition Regulations ("FAR") (or any successor
.\" regulations) or, in the cases of NASA, in paragraph 18.52.227-86 of the
.\" NASA Supplement to the FAR (or any successor regulations).
.\"
.\" =========================================================================
.\" 
.\" Commercial licensing and support of this software is available from
.\" OpenSS7 Corporation at a fee.  See http://www.openss7.com/
.\" 
.\" =========================================================================
.\"
.\" Last Modified 2006/04/05 09:44:41 by brian
.\"
.\" -------------------------------------------------------------------------
.\"
.\" strace.8.man,v
.\" Revision 0.9.2.16  2006/04/05 09:44:41  brian
.\" - moved .so line and updated headers
.\"
.\" =========================================================================
.R1
bracket-label "\fR[\fB" "\fR]" "\fR, \fB"
no-default-database
database strutil.refs
accumulate
move-punctuation
abbreviate A
join-authors ", " ", " " and "
et-al " et al" 2 3
abbreviate-label-ranges ".."
sort-adjacent-labels
.R2
.so strutil.macros
.\"
.\"
.TH STRACE 8 "@PACKAGE_DATE@" "@PACKAGE@-@VERSION@" "@PACKAGE_TITLE@ Administration"
.\"
.\"
.SH NAME
.B strace
\- write \fISTREAMS\fR event trace messages to the standard output
.\"
.\"
.SH SYNOPSIS
.PP
.ad l
.hy 0
.HP \w'strace\ 'u
\fBstrace\fR [\fIoptions\fR]
[\fB-nqDv\fR]
[{\fB-d\fR|\fB--directory\fR[=]}\fIdirectory\fR]
[{\fB-p\fR|\fB--pidfile\fR[=]}[\fIpidfile\fR]]
[{\fB-l\fR|\fB--logdev\fR[=]}[\fIlogdevice\fR]]
[{\fB-D\fR|\fB--debug\fR[=]}[\fILEVEL\fR]]
[{\fB-v\fR|\fB--verbose\fR[=]}[\fILEVEL\fR]]
[\fImid\fR \fIsid\fR \fIlevel\fR] ...
.PD 0
.HP
\fBstrace\fR {\fB-h\fR|\fB--help\fR}
.HP
\fBstrace\fR {\fB-V\fR|\fB--version\fR}
.HP
\fBstrace\fR {\fB-C\fR|\fB--copying\fR}
.PD
.ad b
.hy 6
.\"
.\"
.SH DESCRIPTION
.PP
The
.B strace
receives trace event messages from the
.I STREAMS
log driver
.RB ( log (4))
and writes these messages to standard output.
When run as a daemon,
.B strace
appends these messages to a log file.
The error log files produced
reside in the directory
.BR /var/adm/streams " or " /var/log/streams ,
or a user-specified directory,
and are named
.BI trace. mm-dd\fR,
where
.I mm
is the month and
.I dd
is the day of the messages contained in each log file.
.PP
By default,
.B strace
without arguments writes all
.I STREAMS
trace messages from all drivers and modules.
.B strace
with command-line arguments limits the trace messages received.
.PP
Messages that appear in the trace log are intended to report debugging
information that assists with troubleshooting a running
.I STREAMS
module or driver.
Messages indicating the total failure of a
.I STREAMS
driver or module should have the
.B F
flag set.  Those messages requiring the immediate attention of the
administrator should have the
.B N
flag set, which causes the console logger to send the message to that person by
way of the
.BR mail (1)
command.  The priority level usually has no meaning in the error log, but does
have meaning if the message is sent to the trace process.  Messages of lower
priority levels can be filtered out.
.PP
Once initiated, the
.B strace
daemon continues to execute until terminated by the user.  Usually, the
.B strace
daemon is executed asynchronously.
.\"
.\"
.SH OPTIONS
.PP
.TP
\fB-d\fR, \fB--directory\fR \fIdirectory\fR
Specifies a directory to contain the messages.  Default is to search for
.RB \(lq /var/adm/streams \(rq
and then
.RB \(lq /var/log/streams .\(rq
.TP
\fB-n\fR, \fB--noforeground\fR
Daemonize, do not run in the foreground, print output to
.I outfile
and error logs to
.IR errfile .
This option is most usefull for debugging
.BR strace .
.TP
\fB-b\fR, \fB--basename\fR \fIbasename\fR
Specify the log file basename.  Default is
.RB \(lq trace \(rq .
.TP
\fB-o\fR, \fB--outfile\fR \fIoutfile\fR
Specifiy the log file output name.
When run as a daemon, the default is
.RI \(lq basename . mm-dd \(rq,
where
.I mm-dd
is the current month and day of month.
When run in the foreground, the default is ignored and all output is to
.IR stdout .
When specified, standard output is redirected to the specified file regardless of whether
.B strace
is being run in the foreground or as a daemon.
.TP
\fB-e\fR, \fB--errfile\fR \fIerrfile\fR
Specify the error file output name.
When run as a daemon, the default is
.RI \(lq /dev/null \(rq
and all errors are logged to
.BR syslogd (8).
When run in the foreground, the default is ignored and all errors are logged to
.IR stderr .
When specified, standard error is redirected to the specified file regardless of whether
.B strace
is being run in the foreground or as a daemon.
.TP
\fB-p\fR, \fB--pidfile\fR \fIpidfile\fR
Specify the pid file output name.  Default is
.RB \(lq /var/run/strace.pid .\(rq
When run in the foreground, the default is ignored.
.TP
\fB-l\fR, \fB--logdev\fR \fIlogdevice\fR
Specifies the log device.  Default is to search
.RB \(lq /dev/streams/strlog ,\(rq
.RB \(lq /dev/streams/log ,\(rq
.RB \(lq /dev/strlog \(rq
and
.RB \(lq /dev/log .\(rq
.TP
\fB-q\fR, \fB--quiet\fR
Suppresses normal output.
This option is equivalent to
.BR --verbose = 0 .
.TP
\fB-D\fR, \fB--debug\fR [\fIlevel\fR]
Increase or specify the debug output
.IR level .
When a debug
.I level
has been specified,
.B strace
will log to
.IR stdout ,
prints debug messages to
.IR stderr ,
and will not place itself in the background.
This option may be repeated.
.TP
\fB-v\fR, \fB--verbose\fR [\fIlevel\fR]
Increase or specify the verbosity
.I level
of the output.  This option may be repeated.
.TP
\fB-h\fR, \fB--help\fR
When this option is encountered,
.B strace
displays usage information on
.I stdout
and exits.
No further processing of options or arguments is performed and no actions are taken.
.TP
\fB-V\fR, \fB--version\fR
When this option is encountered,
.B strace
displays version information on
.I stdout
and exits.
No further processing of options or arguments is performed and no actions are taken.
.TP
\fB-C\fR, \fB--copying\fR
When this option is encountered,
.B strace
displays copying and copyright information on
.I stdout
and exits.
No further processing of options or arguments is performed and no actions are taken.
.\"
.\"
.SH ARGUMENTS
.PP
The arguments, which must be specified in groups of three, are:
.TP
.I mid
Specifies the
.I STREAMS
module identification number from the
.B streamtab
entry.
.TP
.I sid
Specifies a sub-identification number (often corresponding to a minor device).
.TP
.I level
Specifies a tracing priority level.
.B strace
gets messages of a level equal to or less than the value specified by
.BR level .
Only positive integer values are allowed.
.PP
The value
.RI \*(lq all \*(rq
can be used for any argument in the
.B strace
command line to indicate that there are no restrictions for that argument.
.PP
Multiple sets of the three arguments can be specified to obtain the messages
from more than one driver or module.
When
.B strace
is invoked, the log driver compares the sets of command line arguments with
actual trace message, returning only messages that satisfy the specified
criteria.
.\"
.\"
.SH FORMAT
.PP
.I STREAMS
trace event messages have the following format:
.HP
.RB < seq "> <" time "> <" ticks "> <" level "> <" flags "> <" mid "> <" sid "> <" text >
.PP
Components are interpreted as follows:
.TP \w'<flags>\(em'u
.RB < seq >
Trace sequence number.
.PD 0
.TP
.RB < time >
Time the message was sent expressed in hh:mm:ss.
.TP
.RB < ticks >
Time the message was sent expressed in machine ticks since last boot.
.TP
.RB < level >
Tracing level as defined by the
.I STREAMS
driver or module that originates the messages.
.TP
.RB < flags >
Any combination of the following three message indicators:
.RS
.IP \fBE\fP 3
The message has also been saved in the error log.
.IP \fBF\fP
The message signalled a fatal error.
.IP \fBN\fP
The message has also been mailed to the system administrator.
.RE
.TP
.RB < mid >
Module identification number of the trace message source.
.TP
.RB < sid >
Sub-identification number of the trace message source.
.TP
.RB < text >
Formatted text of the trace message.
.PD
.\"
.\"
.SH DIAGNOSTICS
.PP
An exit status of zero
.RB ( 0 )
indicates that the command was successful; one
.RB ( 1 )
indicates that an error occured and a diagnostic message is printed to
.IR stderr ;
two
.RB ( 2 )
indicates that the option or argument syntax was in error and a
diagnostic message is printed to
.IR stderr .
.PP
The
.B --quiet
option suppresses the printing of diagnostic messages to
.IR stderr .
.\"
.\"
.SH SIGNALS
.PP
.B strace
catches the
.B SIGHUP
signal
.RB "(see " signal (7)).
.TP
.B SIGHUP
When the
.B SIGHUP
signal is caught,
.B strace
will close the current log file and open a new (or reopen the existing) log
file.  This is for use with
.BR logrotate (8).
.TP
.B SIGTERM
When the
.B SIGTERM
signal is caught,
.B strace
flushes and closes all of its log files and then exits.
.\"
.\"
.SH NOTICES
.PP
.BR strace (8)
has no ressemblence to the system-call tracing utility of the same name:
.BR strace (1).
.PP
Only one
.B strace
daemon or process at a time is permitted to open the
.I STREAMS
log driver as a trace logger.
If a module or driver is generating a large number of trace
messages, running the trace logger causes a degradation in
.I STREAMS
performance.  If a large number of messages are generated in a short time, the
log driver may not be able to deliver some of the messages.  This situation is
indicated by gaps in the sequence numbering of the messages in the log files.
.PP
When run in the foreground,
.B strace
runs until terminated by the caller.
.PP
Running
.B strace
with several sets of arguments can impair
.I STREAMS
performance, particularly for those modules and drivers that are sending the
messages.
Also be aware that
.B strace
may not be able to handle a large number of messages.  If drivers and modules
return messages to
.B strace
too quickly, some may be lost.
.PP
Due to performance considerations, only one
.B strace
command is permitted to open the
.I STREAMS
.B log
driver at a time.
The
.B log
driver has a list of the triplets specified in the command invocation, and
compares each potential trace message against this list to decide if it should
be formatted and sent up to the
.B strace
process.  Hence, long lists of triplets have a greater impact on overall
.I STREAMS
performance.
Running the
.B strace
command has the most impact on the timing of modules and drivers generating
the trace messages that are sent to the
.B strace
process.  If trace messages are generated faster than the
.B strace
process can handle them, some of the messages will be lost.  This last case
can be determined by examining the sequence numbers on the trace messages
output.
.\"
.\"
.\".SH EXAMPLES
.\".PP
.\"
.\"
.SH DEVICES
.PP
.TP
.BR /dev/streams/strlog ", " /dev/streams/log ", " /dev/strlog " or " /dev/log
the
.I STREAMS
logging device.
See
.BR strlog (4).
.\"
.\"
.SH FILES
.PP
.TP
.B /usr/sbin/strace
contains the
.B strace
command.
.TP
.BR /var/log/streams " or " /var/adm/streams
directory containing the error log files.
.TP
.BI /var/log/streams/trace. "pid \fR or " /var/adm/streams/trace. pid
trace log file.
.TP
.BR /etc/init.d/strace " or " /etc/strace.sh
an SysV or Debian init script for starting the trace logger.
.\"
.\"
.SH "SEE ALSO"
.PP
.BR log (4),
.BR strlog (4),
.BR strlog (9),
.BR strlog (1),
.BR strerr (8),
.BR strclean (8),
.BR syslogd (8),
.BR syslog (3).
.\"
.\"
.SH BUGS
.PP
.B strace
has no known bugs.
.\"
.\"
.SH COMPATIBILITY
.PP
.B strace
is compatible with
.IR "SVR 4.2" ,
.[
svr42cr
.]
and systems based on
.IR "SVR 4.2" ,
such as
.IR AIX \(rg,
.IR HP-UX \(rg,
.IR OSF/1 \(rg,
.IR Solaris \(rg,
.IR SUPER-UX \(rg,
.IR UnixWare \(rg
and
.IR UXP/V \(rg,
with the following compatibility considerations:
.IP \(em \w'\(em\(em'u
Options
.BR -n ", " -D ", " -b ", " -o ", " -e ", " -p " and " -l ,
and all long options, are specific to this
.I @PACKAGE_TITLE@
implementation of
.B strace
and should not be used by portable applications.
.IP \(em
No other implementation documents the
.BR -q ", " -D ", " -v ", " -h ", " -V " or " -C
options.
They should not be used by portable applications.
.IP \(em
Options
.BR --help " and " --version
are provided for compatibility with GNU coding standards;
.BR --copying ,
OpenSS7 coding standards.
.IP \(em
All other implementations document the log file directory as
.B /var/adm/streams
instead of
.BR /var/log/streams .
.B /var/log/streams
is used under
.B Linux
for compatibility with the
.BR "Linux File Standard" .
For compatibility,
.B strace
first checks if the directory
.B /var/adm/streams
exists, and then creates
.B /var/log/streams
if necessary, unless a directory is specified with the
.B -d
option.
.IP \(em
.B "SVR 4.2"
and systems based on
.B "SVR 4.2"
only describe
.B strace
as operating in the foreground.
.I @PACKAGE_TITLE@
.B strace
permits
.B strace
to be run in the background as a daemon process.  This is useful for running
background, high-level traces in running systems.  This is accomplished in a
manner similar to
.BR strerr (8).
.IP \(em
Under
.IR "SVR 4.2"
.[
svr42cr
.]
and
.IR UnixWare \(rg
.[
uw7doc
.]
the
.I STREAMS
log device is called
.B /dev/log
rather than
.BR /dev/strlog .
.B Linux
already has a
.RB non- STREAMS
based log mechanism (BSD-style) logging device named
.BR /dev/log .
.IP \(em
Under
.IR OSF/1 \(rg
.[
osfdoc
.]
the
.I STREAMS
log device is called
.B /dev/streams/log
instead of
.BR /dev/strlog .
.IP \(em
For compatibility with these operating environments,
.B strace
attempts to open
.BR /dev/streams/strlog ", " /dev/streams/log ", " /dev/strlog " and then " /dev/log
if not specified with the
.B -l
option.
The call to
.B strace
will fail if there is no
.IR STREAMS -based
log device in this search sequence, or specified with the
.B -l
option.
.\"
.\"
.SH CONFORMANCE
.PP
.IR "SVR 4.2" ;
.[
svr42cr
.]
.IR AIX \(rg,
.IR HP-UX \(rg,
.IR OSF/1 \(rg,
.IR Solaris \(rg,
.IR SUPER-UX \(rg,
.IR UnixWare \(rg
and
.IR UXP/V \(rg
documentation.
.[
aixdoc
.]
.[
hpuxdoc
.]
.[
osfdoc
.]
.[
soldoc
.]
.[
suxdoc
.]
.[
uw7doc
.]
.[
uxpdoc
.]
.\"
.\"
.SH HISTORY
.PP
.B strace
first appeared in
.IR "SVR 4" .
.[
svr4
.]
.\"
.\"
.[
$LIST$
.]
.TI
