'\" rtp
.\" -*- nroff -*- vim: ft=nroff nocin nosi
.\"
.\" @(#) fdetach.8.man,v 0.9.2.18 2006/04/05 09:44:41 brian Exp
.\"
.\" =========================================================================
.\"
.\" Copyright (c) 2001-2006  OpenSS7 Corporation <http://www.openss7.com/>
.\"
.\" All Rights Reserved.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a
.\" permission notice identical to this one
.\" 
.\" Since the Linux kernel and libraries are constantly changing, this
.\" manual page may be incorrect or out-of-date.  The author(s) assume no
.\" responsibility for errors or omissions, or for damages resulting from
.\" the use of the information contained herein.  The author(s) may not
.\" have taken the same level of care in the production of this manual,
.\" which is licensed free of charge, as they might when working
.\" professionally.  The author(s) will take no responsibility in it.
.\" 
.\" Formatted or processed versions of this manual, if unaccompanied by
.\" the source, must acknowledge the copyright and authors of this work.
.\"
.\" -------------------------------------------------------------------------
.\"
.\" U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software
.\" on behalf of the U.S. Government ("Government"), the following
.\" provisions apply to you.  If the Software is supplied by the Department
.\" of Defense ("DoD"), it is classified as "Commercial Computer Software"
.\" under paragraph 252.227-7014 of the DoD Supplement to the Federal
.\" Acquisition Regulations ("DFARS") (or any successor regulations) and the
.\" Government is acquiring only the license rights granted herein (the
.\" license rights customarily provided to non-Government users).  If the
.\" Software is supplied to any unit or agency of the Government other than
.\" DoD, it is classified as "Restricted Computer Software" and the
.\" Government's rights in the Software are defined in paragraph 52.227-19
.\" of the Federal Acquisition Regulations ("FAR") (or any successor
.\" regulations) or, in the cases of NASA, in paragraph 18.52.227-86 of the
.\" NASA Supplement to the FAR (or any successor regulations).
.\"
.\" =========================================================================
.\" 
.\" Commercial licensing and support of this software is available from
.\" OpenSS7 Corporation at a fee.  See http://www.openss7.com/
.\" 
.\" =========================================================================
.\"
.\" Last Modified 2006/04/05 09:44:41 by brian
.\"
.\" -------------------------------------------------------------------------
.\"
.\" fdetach.8.man,v
.\" Revision 0.9.2.18  2006/04/05 09:44:41  brian
.\" - moved .so line and updated headers
.\"
.\" =========================================================================
.R1
bracket-label "\fR[\fB" "\fR]" "\fR, \fB"
no-default-database
database strutil.refs
accumulate
move-punctuation
abbreviate A
join-authors ", " ", " " and "
et-al " et al" 2 3
abbreviate-label-ranges ".."
sort-adjacent-labels
.R2
.so strutil.macros
.\"
.\"
.TH FDETACH 8 "@PACKAGE_DATE@" "@PACKAGE@-@VERSION@" "@PACKAGE_TITLE@ Administration"
.\"
.\"
.SH NAME
.B fdetach
\- unlink a named \fISTREAMS\fR file
.\"
.\"
.SH SYNOPSIS
.PP
.HP
\fBfdetach\fR [\fIoptions\fR] [\fIpath\fR]
.PD 0
.HP
\fBfdetach\fR {\fB-h\fR|\fB--help\fR}
.HP
\fBfdetach\fR {\fB-V\fR|\fB--version\fR}
.HP
\fBfdetach\fR {\fB-C\fR|\fB--copying\fR}
.PD
.\"
.\"
.SH OPTIONS
.PP
The following options can be used in conjunction with a
.I path
argument:
.TP
.BR -d ", " --debug " [" \fIlevel\fR ]
Increase or specify the debug verbosity level of the output.  This option may
be repeated.
.TP
.BR -q ", " --quiet
Suppresses normal output.
.TP
.BR -v ", " --verbose " [" \fIlevel\fR ]
Increase or specify the verbosity level of the output.  This option may be
repeated.
.PP
The following options are general command options.  When one of these options is encountered, the
requested information is displayed and
.B fdetach
exits without processing further options or arguments and without performing any other actions.
.TP
.BR -h ", " --help
When this option is encountered,
.B fdetach
displays usage information on
.I stdout
and exits.
.TP
.BR -V ", " --version
When this option is encountered,
.B fdetach
displays version information on
.I stdout
and exits.
.TP
.BR -C ", " --copying
When this option is encountered,
.B fdetach
displays copying and copyright information on
.I stdout
and exits.
.PP
If
.B fdetach
is executed without a
.I path
name, a short usage summary is printed.
.\"
.\"
.SH ARGUMENTS
.PP
.TP
[\fIpath\fR]
the path to the file to which the
.I STREAMS
special file is attached.
.\"
.\"
.SH DESCRIPTION
.PP
The
.B fdetach
command detaches or disassociates a file descriptor for an open
.I STREAMS
device or pipe from its filename in the file system.  The path argument is the
path that was previously associated with the file descriptor with the
.BR fattach (3)
function.
.PP
Operations on path will subsequently affect the file system node, not the
.I STREAMS
device or pipe.  The permission and status of the node are returned to the
state that they were in before the
.I STREAMS
device or pipe was attached.  Any other paths that the
.I STREAMS
device or pipe may be attached to are not affected.
.PP
To successfully issue the
.B fdetach
command, the caller must be superuser or must be the owner of the file and
have write permission.
.\"
.\"
.SH DIAGNOSTICS
.PP
.B fdetach
returns 0 (zero) on success.  If
.B fdetach
fails, it returns 1 and prints a message to
.IR stderr .
.PP
An exit status of zero (0) indicates that the
.B fdetach
command was successful; one (1) indicates that an error occurred and a
diagnostic message is printed to
.IR stderr ;
two (2) indicates that the option syntax was in error and a diagnostic message
is printed to
.IR stderr .
.PP
Errors may result from inadequate permissions, inability to detach the named
stream.
.\"
.\"
.SH NOTICES
.PP
.B fdetach
simply calls
.BR fdetach (3)
for the specified
.IR path .
.\"
.\"
.SH "SEE ALSO"
.PP
.BR fattach (3),
.BR umount (1),
.BR umount (8).
.\"
.\"
.SH BUGS
.PP
.B fdetach
has no known bugs.
.\"
.\"
.SH COMPATIBILITY
.PP
.B fdetach
is compatible with
.IR "SVR 4.2" ,
.[
svr42cr
.]
.IR HP-UX \(rg,
.IR OSF/1 \(rg,
.IR Solaris \(rg,
.IR UnixWare \(rg,
.IR UXP/V \(rg
and
.BR LiS ,
.[
LiS
.]
with the following portability considerations:
.IP \(em \w'\(em\(em'u
.IR AIX \(rg
does not
document
.[
aixspg
.]
support the
.B fdetach
command.  However,
.BR umount (1)
may be used in its stead.
For compatibility with
.IR AIX \(rg,
.I @PACKAGE_TITLE@
supports the use of the
.BR umount (8)
command to detach named streams.
.IP \(em
Versions of
.B fdetach
based on
.B SVR 4.2
do not document long options.
.IP \(em
Versions of
.B fdetach
based on
.B SVR 4.2
do not document the
.BR -q ", " -v ", " -h ", " -V " or " -C
options.
.IP \(em
Options
.BR --help " and " --version
are provided for compatibility with GNU coding standards;
.BR --copying ,
OpenSS7 coding standards.
.\"
.\"
.SH CONFORMANCE
.PP
.IR "SVR 4.2" ;
.[
svr42cr
.]
.IR HP-UX \(rg,
.[
hpuxspg
.]
.IR OSF/1 \(rg,
.[
osfspg
.]
.IR Solaris \(rg,
.[
solspg
.]
.IR UnixWare \(rg
.[
uw7doc
.]
and
.IR UXP/V \(rg
.[
uxpdoc
.]
documentation.
.\"
.\"
.SH HISTORY
.PP
.BR fdetach
first appeared in
.IR "SVR 4" .
.[
svr4
.]
.\"
.\"
.[
$LIST$
.]
.TI
