'\" rtp
.\" -*- nroff -*- vim: ft=nroff nocin nosi
.\"
.\" @(#) fattach.8.man,v 0.9.2.14 2006/04/05 09:44:41 brian Exp
.\"
.\" =========================================================================
.\"
.\" Copyright (c) 2001-2006  OpenSS7 Corporation <http://www.openss7.com/>
.\"
.\" All Rights Reserved.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a
.\" permission notice identical to this one
.\" 
.\" Since the Linux kernel and libraries are constantly changing, this
.\" manual page may be incorrect or out-of-date.  The author(s) assume no
.\" responsibility for errors or omissions, or for damages resulting from
.\" the use of the information contained herein.  The author(s) may not
.\" have taken the same level of care in the production of this manual,
.\" which is licensed free of charge, as they might when working
.\" professionally.  The author(s) will take no responsibility in it.
.\" 
.\" Formatted or processed versions of this manual, if unaccompanied by
.\" the source, must acknowledge the copyright and authors of this work.
.\"
.\" -------------------------------------------------------------------------
.\"
.\" U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software
.\" on behalf of the U.S. Government ("Government"), the following
.\" provisions apply to you.  If the Software is supplied by the Department
.\" of Defense ("DoD"), it is classified as "Commercial Computer Software"
.\" under paragraph 252.227-7014 of the DoD Supplement to the Federal
.\" Acquisition Regulations ("DFARS") (or any successor regulations) and the
.\" Government is acquiring only the license rights granted herein (the
.\" license rights customarily provided to non-Government users).  If the
.\" Software is supplied to any unit or agency of the Government other than
.\" DoD, it is classified as "Restricted Computer Software" and the
.\" Government's rights in the Software are defined in paragraph 52.227-19
.\" of the Federal Acquisition Regulations ("FAR") (or any successor
.\" regulations) or, in the cases of NASA, in paragraph 18.52.227-86 of the
.\" NASA Supplement to the FAR (or any successor regulations).
.\"
.\" =========================================================================
.\" 
.\" Commercial licensing and support of this software is available from
.\" OpenSS7 Corporation at a fee.  See http://www.openss7.com/
.\" 
.\" =========================================================================
.\"
.\" Last Modified 2006/04/05 09:44:41 by brian
.\"
.\" -------------------------------------------------------------------------
.\"
.\" fattach.8.man,v
.\" Revision 0.9.2.14  2006/04/05 09:44:41  brian
.\" - moved .so line and updated headers
.\"
.\" =========================================================================
.R1
bracket-label "\fR[\fB" "\fR]" "\fR, \fB"
no-default-database
database strutil.refs
accumulate
move-punctuation
abbreviate A
join-authors ", " ", " " and "
et-al " et al" 2 3
abbreviate-label-ranges ".."
sort-adjacent-labels
.R2
.so strutil.macros
.\"
.\"
.TH FATTACH 8 "@PACKAGE_DATE@" "@PACKAGE@-@VERSION@" "@PACKAGE_TITLE@ Administration"
.\"
.\"
.SH NAME
.B fattach
\- name a \fISTREAMS\fR file
.\"
.\"
.SH SYNOPSIS
.PP
.HP 12
\fBfattach\fR [\fIoptions\fR] {\fB-p\fR|\fB--pipe\fR} \fIPATH\fR \fI...\fR
.PD 0
.HP
\fBfattach\fR [\fIoptions\fR] {\fB-c\fR|\fB--connld\fR} \fIPATH\fR \fI...\fR
.HP
\fBfattach\fR [\fIoptions\fR] \fIDEVICE\fR \fIPATH\fR \fI...\fR
.HP
\fBfattach\fR {\fB-h\fR|\fB--help\fR}
.HP
\fBfattach\fR {\fB-V\fR|\fB--version\fR}
.HP
\fBfattach\fR {\fB-C\fR|\fB--copying\fR}
.PD
.\"
.\"
.SH OPTIONS
.PP
The following options are command options.  When
.B --pipe
or
.B --connld
or
both are specified, a
.BR pipe (4)
stream is opened and attached to
.IR PATH .
When
.B --connld
is specified, the
.BR connld (4)
module is also pushed onto the pipe end that is then attached.
If neither
.B --pipe
or
.B --connld
is specified, the first non-option argument must be a path to a STREAMS
.I DEVICE
that will be opened and attached instead of a
.BR pipe (4).
.TP
\fB-p\fR, \fB--pipe\fR
create a pipe to attach to
.IR PATH .
.TP
\fB-c\fR, \fB--connld\fR
push
.BR connld (4)
on the first side of the pipe (implies
.BR -p ).
.PP
The following
.I options
can be used in conjunction with the command options listed above.
.TP
\fB-m\fR, \fB--mode\fR
apply the mode of the old file after attaching to
.IR PATH .
.TP
\fB-u\fR, \fB--umask\fR
apply the umask after attaching to
.IR PATH .
.TP
\fB-M\fR, \fB--mode\fR
apply mode
.I MODE
after attaching the
.IR PATH .
.TP
\fB-q\fR, \fB--quiet\fR
suppress normal output (equivalent to
.BR --verbose = 0 ).
.TP
\fB-v\fR, \fB--verbose\fR [\fILEVEL\fR]
increment or set output verbosity to \fILEVEL\fR.  This option can be repeated.
.PP
The following options are general purpose command options.  When the option is encountered, the
information is displayed and
.B fattach
exists without processing further options or arguments.
.TP
\fB-h\fR, \fB--help\fR
When this option is encountered,
.B fattach
displays usage information on
.I stdout
and exits.
.TP
\fB-V\fR, \fB--version\fR
When this option is encountered,
.B fattach
displays version information on
.I stdout
and exits.
.TP
\fB-C\fR, \fB--copying\fR
When this option is encountered,
.B fattach
displays copying and copyright information on
.I stdout
and exits.
.\"
.\"
.SH ARGUMENTS
.PP
.TP
.I DEVICE
a
.I STREAMS
special character device to open and attach.
.TP
.I PATH
the filesystem path to which to attach the open stream.
.\"
.\"
.SH DESCRIPTION
.PP
The
.B fattach
command provides a method for the caller to open a
.I STREAMS
device or
.BR pipe (4),
optionally pushing a
.BR connld (4)
module on the pipe, and attaching the resulting stream to a filesystem path using
.BR fattach (3).
The
.B fattach
command also provides the ability to adjust the permissions on the resulting file attached stream.
.PP
There are three forms of the
.B fattach
command.  The first is used to open a new
.BR pipe (4)
and attach one end to the specified
.IR PATH .
The second form also opens a new
.BR pipe (4)
and attaches one end to the specified
.IR PATH ;
however, it also pushes the
.BR connld (4)
module onto that end of the pipe before attaching it.
The third form is more general and opens the specified
.I DEVICE
and attaches that open stream to
.IR PATH .
.BR fattach (3)
is used to perform the attachment of the stream to
.IR PATH .
.\"
.\"
.SH USAGE
.PP
.B fattach
is useful for use by startup scripts and other scripts that cannot directly use the
.BR fattach (3)
library call.  It can be used to establish named streams for servers.  The use of
.BR pipe (4)
and
.BR connld (4)
and their value in establishing local servers without the use of UNIX domain sockets
is described on those manual pages and in Stevens.
.[
advprog
.]
.\"
.\"
.SH DIAGNOSTICS
.PP
An exit status of zero (0) indicates that the command was successful; one (1) indicates that an
error occured and a diagnostic message is printed to
.IR stderr ;
two (2) indicates that the option syntax was in error and a diagnostic message is printed to
.IR stderr .
.\"
.\"
.SH NOTICES
.PP
The
.B fattach
command requires the availability of the
.BR fattach (3)
library call.
.\"
.\"
.SH ENVIRONMENT
.PP
.B fattach
does not examine any environment variables.
.\"
.\"
.SH DEVICES
.PP
.TP
.BR connld (4)
.I STREAMS connection line discipline pipe module.
.TP
.BR /dev/pipe, /dev/spx
.I STREAMS
.BR pipe (4)
devices
.\"
.\"
.SH FILES
.PP
.TP
.B /usr/sbin/fattach
contains the
.B fattach
command
.\"
.\"
.SH SEE\ ALSO
.PP
.BR fdetach (8),
.BR fattach (3),
.BR pipe (4),
.BR connld (4).
.\"
.\"
.SH BUGS
.PP
.B fattach
has no known bugs.
.\"
.\"
.SH COMPATIBILITY
.PP
The
.B fattach
command is an
.BR LiS -specific
command.
Although,
.IR OSF/1 \(rg
documentation
.[
osfspg
.]
mentions
.BR fattach (8),
there is no such manual page.
.IP \(em
Options
.BR --help " and " --version
are provided for compatibility with GNU coding standards;
.BR --copying ,
OpenSS7 coding standards.
.\"
.\"
.SH CONFORMANCE
.PP
.B LiS
.[
lis
.]
documentation.
.\"
.\"
.SH HISTORY
.PP
.B fattach
first appeared in
.BR LiS .
.[
lis
.]
.\"
.\"
.[
$LIST$
.]
.TI

