'\" rtp
.\" -*- nroff -*- vim: ft=nroff nocin nosi
.\"
.\" @(#) autopush.8.man,v 0.9.2.18 2006/04/05 09:44:41 brian Exp
.\"
.\" =========================================================================
.\"
.\" Copyright (c) 2001-2006  OpenSS7 Corporation <http://www.openss7.com/>
.\"
.\" All Rights Reserved.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a
.\" permission notice identical to this one
.\" 
.\" Since the Linux kernel and libraries are constantly changing, this
.\" manual page may be incorrect or out-of-date.  The author(s) assume no
.\" responsibility for errors or omissions, or for damages resulting from
.\" the use of the information contained herein.  The author(s) may not
.\" have taken the same level of care in the production of this manual,
.\" which is licensed free of charge, as they might when working
.\" professionally.  The author(s) will take no responsibility in it.
.\" 
.\" Formatted or processed versions of this manual, if unaccompanied by
.\" the source, must acknowledge the copyright and authors of this work.
.\"
.\" -------------------------------------------------------------------------
.\"
.\" U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software
.\" on behalf of the U.S. Government ("Government"), the following
.\" provisions apply to you.  If the Software is supplied by the Department
.\" of Defense ("DoD"), it is classified as "Commercial Computer Software"
.\" under paragraph 252.227-7014 of the DoD Supplement to the Federal
.\" Acquisition Regulations ("DFARS") (or any successor regulations) and the
.\" Government is acquiring only the license rights granted herein (the
.\" license rights customarily provided to non-Government users).  If the
.\" Software is supplied to any unit or agency of the Government other than
.\" DoD, it is classified as "Restricted Computer Software" and the
.\" Government's rights in the Software are defined in paragraph 52.227-19
.\" of the Federal Acquisition Regulations ("FAR") (or any successor
.\" regulations) or, in the cases of NASA, in paragraph 18.52.227-86 of the
.\" NASA Supplement to the FAR (or any successor regulations).
.\"
.\" =========================================================================
.\" 
.\" Commercial licensing and support of this software is available from
.\" OpenSS7 Corporation at a fee.  See http://www.openss7.com/
.\" 
.\" =========================================================================
.\"
.\" Last Modified 2006/04/05 09:44:41 by brian
.\"
.\" -------------------------------------------------------------------------
.\"
.\" autopush.8.man,v
.\" Revision 0.9.2.18  2006/04/05 09:44:41  brian
.\" - moved .so line and updated headers
.\"
.\" =========================================================================
.R1
bracket-label "\fR[\fB" "\fR]" "\fR, \fB"
no-default-database
database strutil.refs
accumulate
move-punctuation
abbreviate A
join-authors ", " ", " " and "
et-al " et al" 2 3
abbreviate-label-ranges ".."
sort-adjacent-labels
.R2
.so strutil.macros
.\"
.\"
.TH AUTOPUSH 8 "@PACKAGE_DATE@" "@PACKAGE@-@VERSION@" "@PACKAGE_TITLE@ Administration"
.\"
.\"
.SH NAME
.B autopush
\- control the autopush module list for a \fISTREAMS\fP device
.\"
.\"
.SH SYNOPSIS
.PP
.HP
\fBautopush \fR[\fIoptions\fR]\fB \fR{\fP-f\fR|\fP--file\fR}\fP \fIfilename\fP
.PD 0
.HP
\fBautopush \fR[\fIoptions\fR]\fB \fR{\fP-g\fR|\fP--get\fR} [{\fP-M \fR[\fImajor\fR|\fIname\fR]|\fB-N \fIdriver\fR} [\fB-m\fI minor\fR]]\fP
.HP
\fBautopush \fR[\fIoptions\fR]\fB \fR{\fP-r\fR|\fP--reset\fR} [{\fP-M \fR[\fImajor\fR|\fIname\fR]|\fB-N \fIdriver\fR} [\fB-m\fI minor\fR]]\fP
.HP
\fBautopush \fR[\fIoptions\fR]\fB \fR{\fP-s\fR|\fP--set\fR} {\fP-M \fR[\fImajor\fR|\fIname\fR]|\fB-N \fIdriver\fR} [\fB-m\fI minor\fR [\fB-l\fI lastminor\fR]]\fI module\fB \fR[\fI...\fR]\fP
.HP
\fBautopush \fR[\fIoptions\fR]\fB \fR{\fP-c\fR|\fP--clone\fR} {\fP-M \fR[\fImajor\fR|\fIname\fR]|\fB-N \fIdriver\fR} [\fB-m\fI minor\fR]\fP
.HP
\fBautopush \fR[\fIoptions\fR]\fB \fR{\fP-V\fR|\fP--verify\fR}\fI module\fB \fR[\fI...\fR]\fP
.HP
\fBautopush \fR{\fP-h\fR|\fP--help\fR}\fP
.HP
\fBautopush \fR{\fP-v\fR|\fP--version\fR}\fP
.HP
\fBautopush \fR{\fP-C\fR|\fP--copying\fR}\fP
.PD
.\"
.\"
.SH DESCRIPTION
.PP
.B autopush
is a utility for configuring the modules in the autopush list for a
.IR STREAMS (4)
driver.
The utility is a user utility interface to the
.I STREAMS
Administrative Driver,
.BR sad (4).
.\"
.\"
.SH OPTIONS
.PP
.TP
.BI -f ", " --file " filename"
Specifies a
.I filename
containing the autopush specification.
This option requires privilege (access to the
.BR sad (4)
device
.BR /dev/sad/admin ).
With this option,
.B autopush
reads the file specified by
.I filename
and attempts to configure all of the autopush entries that appear in that
file.  The file format is described in
.IR "\*(lqFILE FORMAT\*(rq" ,
below.
This option is intended to be used from init scripts.
.TP
.BI -g ", " --get
Gets (displays) the autopush list for a
.I STREAMS
driver.
This option does not require privilege (only access to the
.BR sad (4)
device
.BR /dev/sad/user ).
.sp
With this option,
.B autopush
displays the autopush configuration associated with
the devices specified by the
.BR -N ", " -M " and " -m
options.
Only one of
.BR -N " and " -M
may be specified.
If neither
.BR -N " nor " -M
are specified, then information will be displayed for all devices.
If
.BR -m
is not specified, it is assumed to be zero (0).
The display format is illustrated under
.IR \*(lqEXAMPLES\*(rq ,
below.
.TP
.BI -r ", " --reset
Resets (clears) the autopush list for a
.I STREAMS
driver.
This option requires privilege.
With this option,
.B autopush
removes the autopush configuration associated with
the devices specified by the
.BR -N ", " -M " and " -m
options.
Only one of
.BR -N " and " -M
may be specified.
If neither
.BR -N " nor " -M
are specified, then a reset will be attempted for all devices.
If
.BR -m
is not specified, it is assumed to be zero (0).
.TP
.BI -s ", " --set
Sets the autopush list for a
.I STREAMS
driver.
This option requires privilege.
With this option,
.B autopush
sets the autopush configuration for
the devices specified by the
.BR -N ", " -M ", " -m " and " -l
options,
to the module list specified on the command line.
One of
.BR -N " or " -M
must be specified.
If
.BR -m
is not specified, it is assumed that the autopush configuration is to be set
for all minor devices.
If
.BR -l
is specified, the autopush configuration applies to the range of minor devices
from 
.I minor
to
.I lastminor
inclusive.
.I lastminor
must always be greater than
.I minor .
.TP
.BI -c ", " --clone
Set clone minor devices for a
.I STREAMS
driver.
This option requires privilege.
With this option,
.B autopush
sets as being clone devices or redirected open channels
the devices specified by the
.BR -N ", " -M ", " -m " and " -l
options.
One of
.BR -N " or " -M
must be specified.
If
.BR -m
is not specified, it is assumed that the autopush configuration is to be set
for all minor devices.
If
.BR -l
is specified, the autopush configuration applies to the range of minor devices
from 
.I minor
to
.I lastminor
inclusive.
.I lastminor
must always be greater than
.I minor .
.TP
.BI -V ", " --verify " module " ...
Verify that each module in the provided module list is resident on the system.
This option requires privilege.
With this option,
.B autopush
verifies the module list specified on the command line.
.TP
.BI -h ", " --help
When this option is encountered,
.B autopush
displays a usage messsage on
.I stderr
and exits.
.TP
.BI -v ", " --version
When this option is encountered,
.B autopush
displays the version on
.I stderr
and exits.
.TP
.BI --copying
Provides copying and copyright information and exits.
.PP
If none of
.BR -f ,
.BR -g ,
.BR -r ,
.BR -s ,
.BR -V ,
.BR -h " or " -v
are specified,
a usage message is displayed on
.IR stderr .
.TP
.BI -N ", " --name " driver"
Specifies the driver name.  This is the same name with which the driver
appears in
.B /proc/devices
and
.BR /proc/streams/drivers .
When the driver is registered for more than one major device number and the
command applies to all minor device numbers, the command will apply to all
major device numbers associated with the driver.
Used with
.BR -g ", " -r " and " -s
options.
.TP
\fB-M\fI, \fB--major\fR [\fImajor\fR|\fIname\fR]\fP
Specifies the major device number or driver name of the driver.
Used with
.BR -g ", " -r " and " -s
options.
.TP
.BI -m ", " --minor " minor"
Specifies the minor device number, or the first minor device number of a
range.  Used with
.BR -g ", " -r " and " -s
options.
.TP
.BI -l ", " --lastminor " lastminor"
Specifies the last minor device number of a range.  Used with
.BR -s .
.TP
\fImodule\fP \fR[\fI...\fR]\fP
The name of a module or modules that are to be configured for autopush
or to be verified.
Used with
.BR -s " and " -V
options.
.PP
Additional options:
.TP
\fB-d\fR, \fB--debug\fR [\fIlevel\fR]
Increases verbosity of output to debug level.  This is for debugging
.B autopush
and for gaining additional diagnostic information as to what caused an error
exit status.
.TP
.BR -q ", " --quiet
Suppresses normal output to both
.I stdout
and
.IR stderr .
Option and command line syntax errors are still reported.
.\"
.\"
.SH "FILE FORMAT"
.PP
When the
.BR -f " or " -file
.I filename
option is specified, the format the supplied file contains autopush specified
entries.
.IP \(bu
Each line in the file contains one entry or comment per line.
.IP \(bu
Each entry consists of of a number of fields delimited by whitespace (see
.BR isspace (3)).
.IP \(bu
Any field that begins with a
.RI \' # \'
character is a comment that continues to the end of the line.
.IP \(bu
Any line containing only a comment (beginning with optional whitespace and a
.RI \' # \'
character) is ignored.
.PP
Each line containing an autopush specification entry consists of the following
fields:
.TP
(1) [\fImajor\fP|\fIname\fP]
The major device number.  This field is either a device name (not beginning
with a digit), or a decimal, hexadecimal or octal major device number
specifying the device to be configured with an autopush list.
.sp
This field is mandatory.
.TP
(2) \fIminor\fP
The minor device number.  This field is a decimal, hexadecimal or octal minor
device number specifying a single minor device or the start of a range of
minor devices.  If the
.I minor
field is
.BR -1 ,
then all minor devices are specified and the field
.I lastminor
is ignored.
.sp
This field is mandatory.
.TP
(3) \fIlastminor\fP
The last minor device number in a range.  This field is a decimal, hexadecimal
or octal minor device number specifying the last of a range of minor devices
in combination with the
.I minor
field, above.  If the
.I lastminor
field is
.BR -1 ,
and the
.I minor
field is specified, it indicates that the minor device is a
.BR clone (4)
deviec or a redirected open channel, and the
.I module
fields must be absent.
.sp
This field is mandatory.
.TP
(4+) \fImodule\fP
The list of module names (separated by whitespace but on the same line) to be
configured against the specified major and minor device or minor device range.
Each module name is the name of the module as it appears (or will appear when
loaded) in the
.B /proc/streams/modules
entry.
The special name
.RI \*(lq [anchor] \*(rq
is used to indicate that an anchor point should be inserted between the
modules.
.RI \*(lq [anchor] \*(rq
can appear multiple times in the list, but only the last such ocurrence will
have any effect.
For more information on anchor points, see the
.I I_ANCHOR
IO control in
.BR streamio (7).
.sp
One of these fields is mandatory when the
.I lastminor
field is other than
.BR -1 .
These fields must be absent when the
.I lastminor
field is
.BR -1 .
.\"
.\"
.SH DIAGNOSTICS
.PP
An exit status of two (2) indicates that option syntax was in error.
.TP
.BR -f " or " --file
An exit status of zero (0) indicates that all entries in the
provided file were configured as specified; one (1) indicates that at least
one entry was not configured.  Diagnostics concerning the line of the file
that failed is printed on
.IR stderr .
.TP
.BR -g " or " --get
An exit status of zero (0) indicates that the specified autopush
list was retrieved, and printed on
.IR stdout ;
one (1) indicates that the specified device is not configured with an autopush
list and a diagnostic is printed on
.IR stderr .
.TP
.BR -r " or " --reset
An exit status of zero (0) indicates that the specified autopush
list was cleared; one (1) indicates that the specified device is not
configured with an autopush list and a diagnostic is printed on
.IR stderr .
.TP
.BR -s " or " --set
An exit status of zero (0) indicates that the autopush module
list was configured as specified; one (1) indicates that an error occurred and
the autopush list was not configured.  A diagnostic is printed on
.IR stderr .
.TP
.BR -c " or " --clone
An exit status of zero (0) indicates that the clone minor
was configured as specified; one (1) indicates that an error occurred and
the clonable minor was not configured.  A diagnostic is printed on
.IR stderr .
.TP
.BR -V " or " --verify
An exit status of zero (0) indicates that all modules in the
verification list where present in the system; one (1) indicates that at least
one module in the list was not present in the system.
.PP
All other failures result in an exit status of one (1) and a diagnostic is
printed on
.IR stderr .
.\"
.\"
.SH NOTICES
.PP
The
.BR -N " or " -M
option may result in the loading of the kernel module corresponding to the
.I STREAMS
driver.  The kernel module loaded will be named
.BI char-major- nnn \fR,
where
.I nnn
is the major device number sought.  This can be a negative side effect if the
major device number does not correspond to a
.I STREAMS
device.
.PP
The
.B -V
option may result in the loading of the kernel module corresponding to
the named
.I STREAMS
module.  The kernel module loaded will be named
.BI streams- xxx \fR,
where
.I xxx
is the module name.
.PP
.B autopush
does not check the credentials of the user.  Any user with permission to
access the
.I STREAMS
Administrative Driver
.BR sad (4)
device
.BR /dev/sad/admin ,
can execute all options.
For security, 
.B autopush
should never be setuid root,
instead, the file permissions on device
.B /dev/sad/admin
should be adjusted to permit authorized access.
.\"
.\"
.SH EXAMPLES
.PP
The output of
.BI "autopush -g -M " 29 " -m " 0
is as follows:
.RS
.nf
\fC\s-2
Major  Minor  Lastminor  Modules
 29      0      1        ldterm ttcompat
\s+2\fP
.fi
.RE
.PP
An example
.B autopush
configuration file
for use with the command
.BI "autopush -f " filename
is as follows:
.RS
.nf
\fC\s-2
#
# autopush - sample configuration file
#

# Major         Minor   Lastminor       Modules

ticots          -1      0               timod tirdwr [anchor]
ticlts          -1      0               timod tirdwr [anchor]
ticotsord       -1      0               timod tirdwr [anchor]
212             -1      0               timod tirdwr [anchor]
0xa4            -1      0x0             timod tirdwr [anchor]
00371           -1      00              sockmod [anchor]
\s+2\fP
.fi
.RE
.\"
.\"
.SH DEVICES
.PP
.TP
.B /dev/sad/admin
.I STREAMS
administrative driver
.RB ( sad (4))
providing system admin access.
.TP
.B /dev/sad/user
.I STREAMS
administrative driver
.RB ( sad (4))
providing user access.
.TP
.B /dev/sad
.I STREAMS
administrative driver
.RB ( sad (4))
providing combined access.
.\"
.\"
.SH FILES
.PP
.TP
.B /usr/sbin/autopush
contains the
.B autopush
command.
.TP
.B /etc/rc.d/init.d/autopush
script to configure the
.I STREAMS
subsystem for autopush at boot time.
.TP
.B /etc/sysconfig/streams/autopush
typical place to put the
.B autopush
configuration file for use with the
.B -f
option.  The
.B autopush
init script looks there.
.TP
.B /proc/streams/strapush
debugs for
.B strapush
structures.
.\"
.\"
.SH "SEE ALSO"
.PP
.BR sad (4),
.BR sc (4),
.BR autopush_add (9),
.BR autopush_del (9),
.BR autopush_vml (9).
.\"
.\"
.SH BUGS
.PP
.B autopush
has no known bugs.
.\"
.\"
.SH COMPATIBILITY
.PP
.I @PACKAGE_TITLE@
.B autopush
is compatible with
.IR "SVR 4.2" ,
.[
svr42
.]
.IR Solaris \(rg,
.IR UnixWare \(rg,
.IR HP-UX \(rg,
.IR AIX \(rg,
.IR OSF/1 \(rg
and
.IR LiS ,
.[
LiS
.]
with the following portability considerations:
.IP \(em \w'\(em\(em'u
.B autopush
options
.BR -f ", " -g ", " -r ", " -M ", " -m " and " -N
are compatible with
.IR UnixWare \(rg.
.IR UnixWare \(rg
does not document long options formats, nor the
.BR -s ", " -c ", " -V ", " -h " or " -v
flags.
.IP \(em
.B autopush
options
.BR -f ", " -g ", " -r ", " -M " and " -m
are compatible with
.IR Solaris "\(rg and " OSF/1 \(rg.
.IR Solaris "\(rg and " OSF/1 \(rg
do not document long options formats, nor the
.BR -s ", " -c ", " -V ", " -h ", " -v " or " -N
flags.
.IP \(em
.B autopush
options
.BR -f ", " -g ", " -r ", " -M " and " -m
are compatible with
.IR AIX "\(rg and " HP-UX \(rg.
.IR AIX "\(rg and " HP-UX \(rg
provide that the argument to the
.B -M
option can be either a major number or a name.
.B autopush
supports this as well.
.IR AIX "\(rg and " HP-UX \(rg
do not document long options formats, nor the
.BR -s ", " -c ", " -V ", " -h ", " -v " or " -N
flags.
.IP \(em
.B autopush
.BR -f " filename"
file formats are compatible with both
.IR Solaris \(rg,
.IR UnixWare \(rg,
.IR HP-UX \(rg,
.IR AIX \(rg
and
.IR OSF/1 \(rg,
including the
.IR UnixWare \(rg
use of -1 in the
.I lastminor
position to specify that the specified minor device is a
.BR clone (4)
device or redirected open channel, and the
.IR Solaris \(rg
use of the special module name
.RI \*(lq [anchor] \*(rq.
.IP \(em
.B autopush
directly implements the driver name function in the
.BR sad (4)
driver.
.IR AIX "\(rg and " HP-UX \(rg
mention using the
.BR sc (4)
module to enhance the
.BR sad (4)
driver.
.I @PACKAGE_TITLE@
also provides an
.BR sc (4)
module that can be pushed (or not) to the same effect.
.IP \(em
.B LiS
.[
LiS
.]
provides a
.BR sad (4)
driver but does not provide an
.B autopush
command.
.I @PACKAGE_TITLE@
provides for this deficiency.
.IP \(em
Options
.BR --help " and " --version
are provided for compatibility with GNU coding standards;
.BR --copying ", " --debug ", " --verbose " and " --quiet ,
OpenSS7 coding standards.
.PP
.I @PACKAGE_TITLE@
provides a number of additional options.  Portable configurations should use
only short options and should limit themselves to the following three forms of
the command:
.RS
.PP
.BI "autopush -f " filename
.br
.BI "autopush -g -M " major " -m " minor
.br
.BI "autopush -r -M " major " -m " minor
.RE
.PP
In addition, use of
.B -1
for the
.I lastminor
argument,
use of a driver name for the
.I major
argument,
or use of the special module name
.RI \*(lq [anchor] \*(rq
should be avoided.
.\"
.\"
.SH CONFORMANCE
.PP
.IR "SVR 4.2" ;
.[
svr42cr
.]
.IR UnixWare \(rg,
.IR Solaris \(rg,
.IR HP-UX \(rg,
.IR AIX \(rg
and
.IR OSF/1 \(rg
documentation.
.\"
.\"
.SH HISTORY
.PP
.B autopush
first appeared in
.IR "SVR 4" .
.[
svr4
.]
.\"
.\"
.[
$LIST$
.]
.TI
