'\" rtp
.\" -*- nroff -*- vim: ft=nroff nocin nosi
.\"
.\" @(#) strlog.4.man,v 0.9.2.16 2006/04/05 09:44:39 brian Exp
.\"
.\" =========================================================================
.\"
.\" Copyright (c) 2001-2006  OpenSS7 Corporation <http://www.openss7.com/>
.\"
.\" All Rights Reserved.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a
.\" permission notice identical to this one
.\" 
.\" Since the Linux kernel and libraries are constantly changing, this
.\" manual page may be incorrect or out-of-date.  The author(s) assume no
.\" responsibility for errors or omissions, or for damages resulting from
.\" the use of the information contained herein.  The author(s) may not
.\" have taken the same level of care in the production of this manual,
.\" which is licensed free of charge, as they might when working
.\" professionally.  The author(s) will take no responsibility in it.
.\" 
.\" Formatted or processed versions of this manual, if unaccompanied by
.\" the source, must acknowledge the copyright and authors of this work.
.\"
.\" -------------------------------------------------------------------------
.\"
.\" U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software
.\" on behalf of the U.S. Government ("Government"), the following
.\" provisions apply to you.  If the Software is supplied by the Department
.\" of Defense ("DoD"), it is classified as "Commercial Computer Software"
.\" under paragraph 252.227-7014 of the DoD Supplement to the Federal
.\" Acquisition Regulations ("DFARS") (or any successor regulations) and the
.\" Government is acquiring only the license rights granted herein (the
.\" license rights customarily provided to non-Government users).  If the
.\" Software is supplied to any unit or agency of the Government other than
.\" DoD, it is classified as "Restricted Computer Software" and the
.\" Government's rights in the Software are defined in paragraph 52.227-19
.\" of the Federal Acquisition Regulations ("FAR") (or any successor
.\" regulations) or, in the cases of NASA, in paragraph 18.52.227-86 of the
.\" NASA Supplement to the FAR (or any successor regulations).
.\"
.\" =========================================================================
.\" 
.\" Commercial licensing and support of this software is available from
.\" OpenSS7 Corporation at a fee.  See http://www.openss7.com/
.\" 
.\" =========================================================================
.\"
.\" Last Modified 2006/04/05 09:44:39 by brian
.\"
.\" -------------------------------------------------------------------------
.\"
.\" strlog.4.man,v
.\" Revision 0.9.2.16  2006/04/05 09:44:39  brian
.\" - moved .so line and updated headers
.\"
.\" =========================================================================
.R1
bracket-label "\fR[\fB" "\fR]" "\fR, \fB"
no-default-database
database strutil.refs
accumulate
move-punctuation
abbreviate A
join-authors ", " ", " " and "
et-al " et al" 2 3
abbreviate-label-ranges ".."
sort-adjacent-labels
.R2
.so strutil.macros
.\"
.\"
.TH STRLOG 4 "@PACKAGE_DATE@" "@PACKAGE@-@VERSION@" "@PACKAGE_TITLE@ Devices"
.\"
.\"
.SH NAME
.B strlog, log
\- \fISTREAMS\fP log device
.\"
.\"
.SH SYNOPSIS
.PP
.B #include <unistd.h>
.br
.B #include <stropts.h>
.br
.B #include <strlog.h>
.br
.B #include <syslog.h>
.HP 12
.BI "int " fd " = open(" /dev/strlog ", " oflag );
.PD 0
.HP 12
.BI "int " fd " = open(" /dev/conslog ", " oflag );
.PD
.\"
.\"
.SH DESCRIPTION
.PP
.I fd
is a file descriptor for an strlog stream opened using the
.BR open (2)
system call on one of the following devices:
.TP
.RI \*(lq /dev/strlog ",\*(rq \*(lq" /dev/streams/strlog \*(rq
This clone device is accessible to all users.  This device can either be used by a console, error or trace
logger, or can be used to generate log messages with
.BR putmsg (2).
.TP
.RI \*(lq /dev/conslog ",\*(rq \*(lq" /dev/streams/conslog \*(rq
This non-clone device is accessble to all users.  This device can be used to generate log messages
to the console with
.BR putmsg "(2) or " write (2).
.PP
The
.B strlog
device is characterized by the following behaviour:
.PP
The
.B strlog
driver is a
.I STREAMS
software device driver that provides an interface for the
.I STREAMS
console logging
.BR ( strlogd (8)),
error logging
.RB ( strerr (8))
and
event tracing
.RB ( strace (8))
processes.
The
.B strlog
driver presents two separate interfaces:
.IP \(bu
A function call interface in the kernel
.RB ( strlog (9))
through which
.I STREAMS
driver and modules submit log messages.
.IP \(bu
A subset of ioctl
.RB ( streamio (7))
operations and
.I STREAMS
messages for interaction with a user-level
console logger
.RB ( strlogd (8)),
error logger
.RB ( strerr (8)),
trace logger
.RB ( strace (8)),
or processes that need to submit their own log messages
.RB ( strlog (1)).
.SS "Kernel Interface"
.PP
The log messages are generated within the kernel by calls to the
.BR strlog (9)
utility.
.SS "User Interface"
.PP
The
.B strlog
driver is opened using the clone interface,
.BR /dev/strlog ,
or the non-clone interface
.BR /dev/conslog .
.PP
Each open of the
.B /dev/strlog
device obtains a separate stream to
.BR strlog .
To receive log messages, a process first notifies the
.B strlog
driver whether it is a console logger, an error logger or a trace logger by using the
.I I_STR
.RB ( streamio (7))
operation.
.PP
For the console logger, the
.I I_STR
operation has a
.B ic_cmd
parameter value of
.BR I_CONSLOG
with no accompanying data.
.PP
For the error logger, the
.I I_STR
operation has a
.B ic_cmd
parameter value of
.BR I_ERRLOG
with no accompanying data.
.PP
For the trace logger, the
.I I_STR
operation has an
.B ic_cmd
parameter value of
.BR I_TRCLOG ,
and must be accomplished by a data buffer containing an array of one or more
.B trace_ids
structures.  Each
.B trace_ids
structure specifies a
.IR mid ", " sid " and " level
field from which messages are to be accepted.  The
.BR strlog (9)
subroutine accepts messages whose values in the
.IR mid " and " sid
fields exactly match those in the
.B trace_ids
structure, and whose
.I level
is less than or equal to the
.I level
given in the
.B trace_ids
structure.  A value of
.B -1
in any of the fields of the
.B trace_ids
structure indicates that any value is accepted for that field.
.PP
Following is the format of the
.B trace_ids
structure:
.PP
.nf
\fC\s-1
struct trace_ids {
    short   ti_mid;
    short   ti_sid;
    char    ti_level;
    short   ti_flags;
};
\s+1\fP
.fi
.TP
.I ti_mid
specifies the
.I STREAMS
module ID number for this trace id entry.  A value of minus one
.RB ( -1 )
indicates that this trace id entry applies to any module ID.
.TP
.I ti_sid
specifies the sub-ID number of a minor device (unit) associated with the
.I STREAMS
module or driver specified by
.IR t_mid .
A value of minus one
.RB ( -1 )
indicates that this trace id entry applies to any sub-ID.
.TP
.I ti_level
specifies that maximum
.B strlog
log level that will be accepted by this trace id entry.
A value of minus one
.RB ( -1 )
indicates that this trace id entry applies to any log level.
.TP
.I ti_flags
this member is only present for
.IR AIX \(rg
.IR HP-UX \(rg
and
.IR OSF/1 \(rg
(Mentat) implementations and serves no purpose for the user.  It is not used to filter trace
messages.
.PP
If any of the fields of the
.B trace_ids
structure contain a value of
.BR -1,
.B strlog
will accept whatever value it receives in that field.  Otherwise,
.B strlog
only accepts messages if the values of
.IR mid " and " sid
are the same as their counterparts in the
.B trace_ids
structure, and if the message's
.I level
is equal to or less than the
.I level
value in the
.B trace_ids
structure.
.PP
At most, one console logger, one error logger and one trace logger can be active
at a time.  After the logger process has identified itself by using the ioctl
.RB ( streamio (7))
operation, the
.B strlog
driver will begin sending messages, subject to the restrictions previously
noted.  These messages are obtained by using the
.BR getmsg (2)
system call.  The control part of the message contains a
.B log_ctl
structure, which specifies the
.IR mid ", " sid ", " level " and " flags
fields, as well as the time in ticks since boot that the message was submitted,
the corresponding time in seconds since Jan. 1, 1970, and a sequence number.
The time in seconds since 1970 is provided so that the date and time of the
message can be easily computed; the time in ticks since boot is provided so that
the relative timing of log messages can be determined.
.PP
.nf
\fC\s-1
struct log_ctl {
    short   mid;
    short   sid;
    char    level;
    short   flags;
    long    ltime;
    long    ttime;
    int     seq_no;
    int     pri;
};
\s+1\fP
.fi
.TP
.I mid
specifies the
.I STREAMS
module ID number for the driver or module submitting the log message.
.TP
.I sid
specifies the sub-ID number of a minor device (unit) associated with the
.I STREAMS
module or driver identified by
.IR mid .
.TP
.I level
specifies the level for screening lower-level event messages from a tracer.
.TP
.I flags
contains several flags that can be set in various combinations.  The flags are
as follows:
.RS
.TP \w'SL_CONSOLE\(em'u
.B SL_CONSOLE
message is for the console logger.
.PD 0
.TP
.B SL_ERROR
message is for the error logger.
.TP
.B SL_TRACE
message is for the trace logger.
.TP
.B SL_FATAL
notification of a fatal error.
.TP
.B SL_WARN
message is a warning.
.TP
.B SL_NOTE
message is a note.
.TP
.B SL_NOTIFY
requests to mail a copy of a message to the system administrator.
.PD
.RE
.TP
.I ltime
time in seconds since January 1, 1970.
.TP
.I ttime
time in ticks since boot time.
.TP
.I seq_no
a sequence number for the log message.
.TP
.I pri
specifies the priority code and facility code, found in
.BR <sys/syslog.h> .
If
.B SL_CONSOLE
is set in flags, the priority code is set as follows: If
.B SL_WARN
is set, the priority code is set to
.BR LOG_WARNING ;
if
.B SL_FATAL
is set, the priority code is
.BR LOG_ERR ;
.BR SL_NOTE ,
the priority code is
.BR LOG_NOTICES ;
.BR SL_TRACE ,
.BR LOG_DEBUG ;
otherwise,
.BR LOG_INFO .
Messages originating from the kernel have facility code set to
.BR LOG_KERN .
Most message originating from user processes will have the facility code set
to
.BR LOG_USER .
.PP
Different sequence number are maintained for the error logging and trace logging
streams so that gaps in the sequence of messages can be determined.  (During
times of high message traffic, some message may not be delivered by the logger
to avoid tying up system resources).
.PP
The data part of the message contains the unexpanded text of the format string
(null-terminated), followed by the arguments to the format string (up to the
number specified by the
.B NLOGARGS
value), aligned on the first word
.RB ( int )
boundary following the format string.
The format string can be a maximum of
.B LOGMSGSZ
in length.  Longer format messages will be truncated.
.PP
A process may also send a message of the same structure to the log driver, even
if it is not a console, error or trace logger.  The only fields of the
.B log_ctl
structure in the control part of the message that are accepted are the
.IR level " and " flags
fields.  All other fields are filled in by the log driver before being forwarded
to the appropriate logger.  The data portion must contain a null-terminated
format string, of maximum length
.BR LOGMSGSZ ,
and any arguments (up to
.BR NLOGARGS )
must be packed in an integral number of words
.RB ( int )
each, on the next word
.RB ( int )
boundary following the end of the format string.
.PP
In addition, a process may also send a message of the same structure to the
console logger using the
.B log_ctl
structure and the
.BR putmsg (2)
system call, or can simply write the data portion of the message using the
.BR write (2)
system call.
.PP
The
.BR strlog (1)
facility is provided for issuing console, error and trace log messages from shell scripts.
This is similar to the POSIX
.BR logger (1)
command.
.PP
Attempting to issue an
.IR I_TRCLOG ", " I_ERRLOG " or " I_CONSLOG
operation when a logging process of the given type already exists result in
the
.RB [ ENXIO ]
error being returned.  Similarly,
.RB [ ENXIO ]
is returned for
.I I_TRCLOG
operations without any
.B trace_ids
structures, or for any unrecognized
.I I_STR
operations.  Incorrectly formatted log messages sent to the driver by a user
process are silently ignored (no error results).
.\"
.\"
.SH USAGE
.PP
The
.B strlog
device can be opened when no other suitable device exists and modules may be
pushed on the
.B strlog
device.
.\"
.\"
.SH IOCTLS
.PP
The
.B strlog
driver only supports
.BR streamio (7)
.B I_STR
input output controls.
.I TRANSPARENT
input output controls are not supported and will result in a return value of
.RB [ ENXIO ].
The
.B strlog
drivers supports the following
.BR streamio (7)
.B I_STR
input ouput controls:
.SS I_TRCLOG
.PP
Indicates a trace logger.  A data buffer consisting of an array of one or more
.B trace_ids
structures must be included.
.SS I_ERRLOG
.PP
Indicates an error logger.  No
.B trace_ids
is required.
.SS I_CONSLOG
.PP
Indicates a console logger.  No
.B trace_ids
is required.
.\"
.\"
.SH NOTICES
.PP
This device is provided as
.B /dev/strlog
instead of
.B /dev/log
as is the case for
.IR "SVR 4.2"
.[
svr42
.]
systems, because
.B Linux
already has a
.RI non- STREAMS
driver called
.BR /dev/log .
.\"
.\"
.SH EXAMPLES
.PP
.IP 1.
The following is an example of
.I I_ERRLOG
notification:
.RS
.nf
\fC\s-1
struct strioctl ioc;
ioc.ic_cmd = I_ERRLOG;
ioc.ic_timout = 0;	/* default timeout (15 secs.) */
ioc.ic_len = 0;
ioc.ic_dp = NULL;
ioctl(log, I_STR, &ioc);
\s+1\fP
.fi
.RE
.IP 2.
The following is an example of
.I I_TRCLOG
notification:
.RS
.nf
\fC\s-1
struct trace_ids tid[2];
tid[0].ti_mid = 2;
tid[0].ti_sid = 0;
tid[0].ti_level = 1;
tid[1].ti_mid = 1002;
tid[1].ti_sid = -1;  /* any sub-id will be allowed */
tid[1].ti_level = -1; /* any level will be allowed */
ioc.ic_cmd = I_TRCLOG;
ioc.ic_timout = 0;
ioc.ic_len = sizeof(tid);
ioc.ic_dp = (char *) tid;
ioctl(log, I_STR, &ioc);
\s+1\fP
.fi
.RE
.IP 3.
The following is an example of submitting a log message (no arguments):
.RS
.nf
\fC\s-1
struct strbuf ctl, dat;
struct log_ctl lc;
char *message = "Honey, I'm home.";
ctl.len = ctl.maxlen = sizeof(lc);
ctl.buf = (char *) &lc;
dat.len = dat.maxlen = strlen(message);
dat.buf = message;
lc.level = 0;
lc.flags = SL_ERROR;
putmsg(log, &ctl, &dat, 0);
\s+1\fP
.fi
.RE
.\"
.\"
.SH DEVICES
.PP
.TP
.B /dev/strlog
The external file system
.I STREAMS
log device.
.TP
.B /dev/conslog
The external file system
console log device.
.TP
.BR /dev/streams/strlog ", " /devices/strlog
The
.BR specfs (5)
shadow special filesystem
.I STREAMS
log device.
.TP
.BR /dev/streams/conslog ", " /devices/conslog
The
.BR specfs (5)
shadow special filesystem
console
log device.
.\"
.\"
.SH "SEE ALSO"
.PP
.BR open (2),
.BR strerr (8),
.BR strace (8),
.BR strlogd (8),
.BR strlog (9),
.BR streamio (7),
.BR strlog (1),
.BR getmsg (2),
.BR putmsg (2),
.BR write (2).
.\"
.\"
.SH BUGS
.PP
.B strlog
has no known bugs.
.\"
.\"
.SH COMPATIBILITY
.PP
.B strlog
is compatible with systems based on
.IR "SVR 4.2",
.[
svr42
.]
including
.IR AIX \(rg,
.IR HP-UX \(rg,
.IR OSF/1 \(rg,
.IR Solaris \(rg,
.IR SUPER-UX \(rg
and
.IR UnixWare \(rg,
with the following portability considerations:
.IP \(em \w'\(em\(em'u
.IR AIX \(rg
does not document the
.B trace_ids
and
.B log_ctl
structures.
.IP \(em
.IR HP-UX \(rg
does not have a
.I pri
field in the
.B log_ctl
structure.
.IP \(em
.IR HP-UX \(rg
does not support priority or facility codes.
.IP \(em
.IR HP-UX \(rg
does not suppor the
.B I_CONSLOG
input output control.
.IP \(em
.IR OSF/1 \(rg
calls this device
.BR /dev/streams/log .
.IP \(em
.IR Solaris \(rg,
.IR SUPER-UX \(rg
and
.IR UnixWare \(rg
do not provide the
.I ti_flags
field of the
.B trace_ids
structure;
.IR AIX \(rg,
.IR HP-UX \(rg
and
.IR OSF/1 \(rg
do.
.IP \(em
.IR Solaris \(rg
declares
.I ltime
to be
.BR clock32_t " or " clock_t ,
and
.I ttime
to be
.BR time32_t " or " time_t ,
depending on a 64 or 32-bit architecture.
.IP \(em
On most systems, the
.I STREAMS
log device is called
.BR /dev/log ;
however,
.B Linux
has a BSD-based log device by that name, so the device
.B /dev/strlog
is used instead.
.\"
.\"
.SH CONFORMANCE
.PP
.IR "SVR 4.2" ,
.[
svr42cr
.]
.IR AIX \(rg,
.IR HP-UX \(rg,
.IR OSF/1 \(rg,
.IR Solaris \(rg,
.IR SUPER-UX \(rg
and
.IR UnixWare \(rg
documentation.
.[
aixdoc
.]
.[
hpuxdoc
.]
.[
osfdoc
.]
.[
soldoc
.]
.[
suxdoc
.]
.[
uw7doc
.]
.\"
.\"
.SH HISTORY
.PP
.B strlog
first appeared in
.IR "SVR 4" .
.[
svr4
.]
.\"
.\"
.[
$LIST$
.]
.TI
