'\" rtp
.\" -*- nroff -*- vim: ft=nroff nocin nosi
.\"
.\" @(#) spx.4.man,v 0.9.2.16 2006/09/18 01:26:01 brian Exp
.\"
.\" =========================================================================
.\"
.\" Copyright (c) 2001-2006  OpenSS7 Corporation <http://www.openss7.com/>
.\"
.\" All Rights Reserved.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a
.\" permission notice identical to this one
.\" 
.\" Since the Linux kernel and libraries are constantly changing, this
.\" manual page may be incorrect or out-of-date.  The author(s) assume no
.\" responsibility for errors or omissions, or for damages resulting from
.\" the use of the information contained herein.  The author(s) may not
.\" have taken the same level of care in the production of this manual,
.\" which is licensed free of charge, as they might when working
.\" professionally.  The author(s) will take no responsibility in it.
.\" 
.\" Formatted or processed versions of this manual, if unaccompanied by
.\" the source, must acknowledge the copyright and authors of this work.
.\"
.\" -------------------------------------------------------------------------
.\"
.\" U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software
.\" on behalf of the U.S. Government ("Government"), the following
.\" provisions apply to you.  If the Software is supplied by the Department
.\" of Defense ("DoD"), it is classified as "Commercial Computer Software"
.\" under paragraph 252.227-7014 of the DoD Supplement to the Federal
.\" Acquisition Regulations ("DFARS") (or any successor regulations) and the
.\" Government is acquiring only the license rights granted herein (the
.\" license rights customarily provided to non-Government users).  If the
.\" Software is supplied to any unit or agency of the Government other than
.\" DoD, it is classified as "Restricted Computer Software" and the
.\" Government's rights in the Software are defined in paragraph 52.227-19
.\" of the Federal Acquisition Regulations ("FAR") (or any successor
.\" regulations) or, in the cases of NASA, in paragraph 18.52.227-86 of the
.\" NASA Supplement to the FAR (or any successor regulations).
.\"
.\" =========================================================================
.\" 
.\" Commercial licensing and support of this software is available from
.\" OpenSS7 Corporation at a fee.  See http://www.openss7.com/
.\" 
.\" =========================================================================
.\"
.\" Last Modified 2006/09/18 01:26:01 by brian
.\"
.\" -------------------------------------------------------------------------
.\"
.\" spx.4.man,v
.\" Revision 0.9.2.16  2006/09/18 01:26:01  brian
.\" - updated manpages and macros
.\"
.\" Revision 0.9.2.15  2006/04/05 09:44:39  brian
.\" - moved .so line and updated headers
.\"
.\" =========================================================================
.R1
bracket-label "\fR[\fB" "\fR]" "\fR, \fB"
no-default-database
database strutil.refs
accumulate
move-punctuation
abbreviate A
join-authors ", " ", " " and "
et-al " et al" 2 3
abbreviate-label-ranges ".."
sort-adjacent-labels
.R2
.so strutil.macros
.\"
.\"
.TH SPX 4 "@PACKAGE_DATE@" "@PACKAGE@-@VERSION@" "@PACKAGE_TITLE@ Devices"
.\"
.\"
.SH NAME
.B spx, pipe
\- \fISTREAMS\fR bi-directional pipe device
.\"
.\"
.SH DESCRIPTION
.PP
The software pipes obtained by the system call
.BR pipe (2)
are not necessarily bidirectional.
.[
xbd5
.]
.[
susv2
.]
.[
susv3
.]
The
.B spx
.I STREAMS
pseudo-device driver provide a mechanism for obtaining
.IR STREAMS -based
pipes that are bidirectional in nature.
.PP
The
.B spx
pseudo-device driver is a regular
.I STREAMS
device driver.
.PP
Because the
.BR open (2)
system call only returns one file descriptor, the following procedure is used
to create two file descriptors with a connected
.IR STREAMS -based
pipe between them:
.IP (1) \w'(000)'u
Open
.B /dev/spx
an obtain a first file descriptor.  At this point there is only half of the
pipe available.
This step obtains
.IR fd [0].
.IP (2)
Open
.B /dev/spx
again to obtain a second file descriptor.  At this point there are two
unconnected stream heads.
This step obtains
.IR fd [2].
.IP (2)
Call
.BR ioctl (2)
with the
.B I_FDINSERT
command (see
.BR streamio (7))
to associate
.IR fd [0]
with
.IR fd [1].
This can either be accomplished by performing an
.B I_FDINSERT
with
.IR fd [1]
on the stream returned as
.IR fd [0];
or, with
.IR fd [0]
on
.IR fd [1].
The data part of the
.B I_FDINSERT
command is ignored, and the control part of the
.B I_FDINSERT
command contains only the file descriptor translated to a queue pointer.
This step connects
.IR fd [0]
to
.IR fd [1]
for a fully connected,
.IR STREAMS -based,
bi-directional pipe.
.\"
.\"
.SH USAGE
.PP
The characteristics of bi-directional
.IR STREAMS -based
pipes
.RB ( spipes )
by comparison to
SVR 3
.[
svr3
.]
style pipes is as follows:
.IP \(bu 2
.B spipes
are bi-directional.  Both sides are opened for both read and write.  Data
written to one end of the pipe can be read by the other.  Both ends of the
pipe can have data written and read.
.IP \(bu 2
.B spipes
can have modules pushed and popped from either side of the pipe.  (See also
.BR pipemod (4).)
.IP \(bu 2
.B spipes
can have the
.BR connld (4)
module can be pushed onto one end of the pipe.
.IP \(bu 2
.B spipes
have controllable flow control and minimum and maximum packet size characteristics.
.IP \(bu 2
.B spipes
permit the use of the
.BR getmsg (2),
.BR getpmsg (2s),
.BR putmsg (2)
and
.BR putpmsg (2s)
system calls on the pipe ends.
.IP \(bu 2
.B spipes
permit the use of
.I STREAMS
IO controls on either pipe end.  See
.BR streamio (7).
.\"
.\"
.SH NOTICES
.PP
Although an
.BR stat (2)
on the
.B /dev/spx
device node will show the node as being a character special device with a
device number corresponding to the
.B spx
driver, an
.BR fstat (2)
on the file descriptor resulting from an
.BR open (2)
call on
.B /dev/spx
will indicate that the file is a fifo.  This is rather normal
.IR UNIX \(rg
behaviour.
.PP
Depending on
.IR Linux \(rg
kernel configuration parameters, it might not be necessary to go to this
extent to create a
.IR STREAMS -based
bidirectional pipe.  When kernel
configuration parameter
.B CONFIG_STREAMS_PIPES_REPLACE
is set, then the SVR 3
.[
svr3
.]
pipe approach used by
.IR Linux \(rg
will be replaced with a bi-directional
.IR STREAMS -based
pipe.  Then, a simple
call to
.BR pipe (2)
will return a bidirectional pipe and it is not necessary to open the
.B spx
driver to obtain one.
.PP
When first opened, a
.B spx
device behaves similar to an Echo Device,
.BR echo (4).
.\"
.\"
.SH IMPLEMENTATION
.PP
.B spx
is not implemented as a normal
.I STREAMS
driver: it is implemented as a shadow special device node under
.BR "Linux Fast-STREAMS" .
.[
lfs
.]
.B Linux Fast-STREAMS
shadow special devices nodes call
.BR pipe_open ()
from
.BR cdev_open ()
instead of
.BR spec_open ()
permitting the
.B pipe
device to intercept and redirect the open call to the appropriate device.
This is consistent with the descriptions for the internal
.BR pipe_open ()
under
.IR "SVR 4" .
.[
magic
.]
.\"
.\"
.SH EXAMPLES
.PP
Following is an example of how to open a
.IR STREAMS -based
pipe:
(see
.BR I_FDINSERT (7)
for more information)
.sp
.nf
\fC\s-1\
int
spipe(int *fd)
{
    int fds[2];
    long ptr;
    struct strfdinsert fdi;
    if ((fds[0] = open("/dev/spx", O_RDWR)) < 0)
        return (-1);
    if ((fds[1] = open("/dev/spx", O_RDWR)) < 0) {
        close(fds[0]);
        return (-1);
    }
    fdi.ctlbuf.maxlen = fdi.ctlbuf.len = sizeof(ptr);
    fdi.ctlbuf.buf = (caddr_t) &ptr;
    fdi.databuf.maxlen = fdi.databuf.len = -1;
    fdi.databuf.buf = NULL;
    fdi.filedes = fds[1];
    fdi.offset = 0;
    fdi.flags = RS_NORM;
    if (ioctl(fds[0], I_FDINSERT, &fdi) < 0) {
        close(fds[0]);
        close(fds[1]);
        return (-1);
    }
    fd[0] = fds[0];
    fd[1] = fds[1];
    return (0);
}
\s+1\fP
.fi
.PP
The
.BR pipe (3)
library call from the
.BR libstreams (3)
library uses the
.BR pipe
device and a specialized
.BR I_PIPE (7)
input-output control more simply as follows:
.sp
.nf
\fC\s-1\
int
pipe(int *fds)
{
    int fd1, fd2;

    if ((fd1 = open("/dev/pipe", O_RDWR)) < 0) {
        return (-1);
    }
    if ((fd2 = open("/dev/pipe", O_RDWR)) < 0) {
        error = errno;
        close(fd1);
        errno = error;
        return (-1);
    }
    if (ioctl(fd1, I_PIPE, fd2) < 0) {
        error = errno;
        close(fd2);
        close(fd1);
        errno = error;
        return (-1);
    }
    fds[0] = fd1;
    fds[1] = fd2;
    return (0);
}

int
pipe_r(int *fds)
{
    int oldtype, ret;

    pthread_setcanceltype(PTHREAD_CANCEL_DISABLE,
                          &oldtype);
    ret = pipe(fds);
    pthread_setcanceltype(oldtype, NULL);
    return (ret);
}
\s+1\fP
.fi
.PP
Following is an example of how to name a
.IR STREAMS -based
pipe:
.sp
.nf
\fC\s-1\
int
nspipe(int *fd, char *path)
{
    struct stat st;
    int old_umask;

    if (spipe(fd) < 0)
        return (-1);
    if (fstat(fd[0], &st) < 0)
        return (-1);
    unlink(path);
    old_umask = umask(0);
    if (mknod(path, S_IFCHR | 0666, st.st_rdev) < 0) {
        umask(old_umask);
        return (-1);
    }
    umask(old_umask);
    return (0);
}
\s+1\fP
.fi
.sp
.PP
Another option under
.B @PACKAGE_TITLE@
is to create a symbolic link from
.I path
into the
.BR /dev/streams/spx/
directory, like so:
.sp
.nf
\fC\s-1\
int
nspipe(int *fd, char *newpath)
{
    struct stat st;
    int old_umask;
    char oldpath[PATH_MAX];

    if (spipe(fd) < 0)
        return (-1);
    if (fstat(fd[0], &st) < 0)
        return (-1);
    snprintf(oldpath, PATH_MAX, "/dev/streams/spx/%d",
             (st->st_ino & 0xffff));
    unlink(newpath);
    old_umask = umask(0);
    if (symlink(oldpath, newpath) < 0) {
        umask(old_umask);
        return (-1);
    }
    umask(old_umask);
    return (0);
}
\s+1\fP
.fi
.PP
The following function will pass a file desriptor to the process at the other
end of the pipe:
(see
.BR I_SENDFD (7)
for more information)
.sp
.nf
\fC\s-1\
int
sendfd(int fd, int sendfd)
{
    if (ioctl(fd, I_SENDFD, sendfd) < 0)
        return (-1);
    return (0);
}
\s+1\fP
.fi
.PP
The following function will receive a file descriptor at the receiving end of
the pipe:
(see
.BR I_RECVFD (7)
for more information)
.sp
.nf
\fC\s-1\
int
recvfd(int fd, int *recvfd)
{
    struct strrecvfd rfd;

    if (ioctl(fd, I_RECVFD, (char *) &rfd) < 0)
        return (-1);
    *recvfd = rfd.fd;
    return (0);
}
\s+1\fP
.fi
.\"
.\"
.SH DEVICES
.PP
.TP
.B /dev/spx
The external filesystem
.I STREAMS
pipe device.
.TP
.BR /dev/streams/spx ", " /devices/spx
The
.BR specfs (5)
shadow special filesystem
.I STREAMS
pipe deivce.
.\"
.\"
.SH "SEE ALSO"
.PP
.BR pipe (2),
.BR open (2),
.BR ioctl (2),
.BR streamio (7),
.BR pipemod (4),
.BR connld (4),
.BR echo (4),
.BR getmsg (2),
.BR getpmsg (2s),
.BR putmsg (2),
.BR putpmsg (2s),
.BR stat (2),
.BR fstat (2).
.\"
.\"
.SH BUGS
.PP
.B spx
has no known bugs.
.\"
.\"
.SH COMPATIBILITY
.PP
.B Linux Fast-STREAMS
.[
lfs
.]
provides the
.B spx
device for compatibility with
.IR AIX \(rg
.[
aixdoc
.]
and
.IR Unixware \(rg.
.[
uw7doc
.]
.IR Solaris \(rg
and
.I LiS
.[
LiS
.]
do not provide an
.B spx
driver.
.IP \(em \w'\(em\(em'u
.IR AIX \(rg
provides a
.B spx
driver.
.[
aixdoc
.]
The use of the
.B spx
driver under
.IR AIX \(rg
is not well documented.
.IP \(em
.IR UnixWare \(rg
provides a
.B spx
driver.
.[
uw7doc
.]
The use of the
.B spx
driver under
.IR UnixWare \(rg
is fairly well documented.
.IP \(em
.I LiS
does not provide a compatible
.B spx
driver.
.IP \(em
.IR UnixWare \(rg
documentation
.[
uw7doc
.]
describes naming an unnamed pipe by making a device node,
.BR mknod (2),
with the device number returned by a call to
.BR stat (2)
on one end of the pipe.
Also, a
.BR symlink (2),
approach is shown under
.RI \(lq EXAMPLES ,\(rq
above.
Although these techniques work with
.BR "Linux Fast-STREAMS" ,
we recommend using
.BR fattach (2)
and
.BR connld (4)
instead.
.IP \(em
The
.B spx
driver is provided for compatibility with
.IR AIX \(rg
and
.IR UnixWare \(rg
only.  The
.B spx
driver should not be used by portable programs.  Portable programs should use
the
.BR pipe (3)
call from the
.BR libstreams (3)
library to obtain a
.IR STREAMS -based
pipe instead.
.IP \(em
Binary compatibility would only be cooincidental.
.PP
See
.BR pipe (3)
for more information.
.\"
.\"
.SH CONFORMANCE
.PP
.IR AIX \(rg
and
.IR UnixWare \(rg
7.1.1
documentation.
.\"
.\"
.SH HISTORY
.PP
.B spx
appears in
.IR AIX \(rg
and
.IR UnixWare \(rg
7.1.1.
.\"
.\"
.[
$LIST$
.]
.TI

