'\" rtp
.\" -*- nroff -*- vim: ft=nroff nocin nosi
.\"
.\" @(#) sc.4.man,v 0.9.2.12 2006/04/05 09:44:39 brian Exp
.\"
.\" =========================================================================
.\"
.\" Copyright (c) 2001-2006  OpenSS7 Corporation <http://www.openss7.com/>
.\"
.\" All Rights Reserved.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a
.\" permission notice identical to this one
.\" 
.\" Since the Linux kernel and libraries are constantly changing, this
.\" manual page may be incorrect or out-of-date.  The author(s) assume no
.\" responsibility for errors or omissions, or for damages resulting from
.\" the use of the information contained herein.  The author(s) may not
.\" have taken the same level of care in the production of this manual,
.\" which is licensed free of charge, as they might when working
.\" professionally.  The author(s) will take no responsibility in it.
.\" 
.\" Formatted or processed versions of this manual, if unaccompanied by
.\" the source, must acknowledge the copyright and authors of this work.
.\"
.\" -------------------------------------------------------------------------
.\"
.\" U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software
.\" on behalf of the U.S. Government ("Government"), the following
.\" provisions apply to you.  If the Software is supplied by the Department
.\" of Defense ("DoD"), it is classified as "Commercial Computer Software"
.\" under paragraph 252.227-7014 of the DoD Supplement to the Federal
.\" Acquisition Regulations ("DFARS") (or any successor regulations) and the
.\" Government is acquiring only the license rights granted herein (the
.\" license rights customarily provided to non-Government users).  If the
.\" Software is supplied to any unit or agency of the Government other than
.\" DoD, it is classified as "Restricted Computer Software" and the
.\" Government's rights in the Software are defined in paragraph 52.227-19
.\" of the Federal Acquisition Regulations ("FAR") (or any successor
.\" regulations) or, in the cases of NASA, in paragraph 18.52.227-86 of the
.\" NASA Supplement to the FAR (or any successor regulations).
.\"
.\" =========================================================================
.\" 
.\" Commercial licensing and support of this software is available from
.\" OpenSS7 Corporation at a fee.  See http://www.openss7.com/
.\" 
.\" =========================================================================
.\"
.\" Last Modified 2006/04/05 09:44:39 by brian
.\"
.\" -------------------------------------------------------------------------
.\"
.\" sc.4.man,v
.\" Revision 0.9.2.12  2006/04/05 09:44:39  brian
.\" - moved .so line and updated headers
.\"
.\" =========================================================================
.R1
bracket-label "\fR[\fB" "\fR]" "\fR, \fB"
no-default-database
database strutil.refs
accumulate
move-punctuation
abbreviate A
join-authors ", " ", " " and "
et-al " et al" 2 3
abbreviate-label-ranges ".."
sort-adjacent-labels
.R2
.so strutil.macros
.\"
.\"
.TH SC 4 "@PACKAGE_DATE@" "@PACKAGE@-@VERSION@" "@PACKAGE_TITLE@ Devices"
.\"
.\"
.SH NAME
.B sc
\- \fISTREAMS\fR configuration module
.\"
.\"
.SH SYNOPSIS
.PP
.B #include <sys/stropts.h>
.br
.B #include <sys/sc.h>
.HP
.IB t " = open(" /dev/nuls ", " 0 );
.HP
.BI ioctl( t ", " I_PUSH ", " \*(lqsc\*(rq );
.\"
.\"
.SH DESCRIPTION
.PP
.B sc
is a
.I STREAMS
configuration module for
.BR "Linux Fast-STREAMS" .
It interprets a set of
.B sc
.BR ioctl (2)
commands and provides information about the streams configuration.
.B sc
does not interpret any
.BR M_DATA ", " M_PROTO " or " M_PCPROTO
messages either from above or below the module.
.B sc
can be pushed on the the null stream
.BR nuls (4)
or any other suitable stream available to the caller (e.g.
.BR sad (4)).
.\"
.\"
.SH USAGE
.PP
The
.B sc
module is not intended to be used directly by application program developers.
It is used by the
.BR scls (8)
utility an other utilities needing to enquire about the configuration of
.BR "Linux Fast-STREAMS" .
.\"
.\"
.SH IOCTLS
.PP
This subsection details the
.BR ioctl (2)
commands that are made available by pushing the
.B sc
module.  For general information on input-output controls for
.I STREAMS
drivers, see
.BR streamio (7).
.\"
.SS SC_IOC_LIST
.PP
.I arg
is a pointer to a
.BR sc_list
structure in the user's address space.
.PP
The
.B sc_list
structure contains the following members:
.PP
.RS
.nf
\fC\s-1\
struct sc_list {
    int sc_nmods;
    struct sc_mlist *sc_mlist;
};
\s+1\fP
.fi
.TP \w'sc_mlist\(em'u
.I sc_nmods
On call specifies the number of
.B sc_mlist
structures that a provided in the caller's buffer pointed to by
.IR sc_mlist .
On return, specifies the number of
.B sc_mlist
structures that are available to be written to the caller's buffer pointed to
by
.IR sc_mlist ,
regardless of the space provided by the caller.
.TP
.I sc_mlist
Provides a pointer to a user buffer that contains at least
.I sc_nmods
number of
.B sc_mlist
structures in an array.
The module will returns nor more than the number of modules available, or the
number of modules requested,  whichever is less.  However,
.I sc_nmods
will always return the number of modules available.
.PP
By calling with a
.I sc_nmods
of zero and a
.I sc_mlist
of
.BR NULL ,
the caller can determine the number of modules that are available to
be returned in
.IR sc_mlist
so that the buffer may be appropriately sized for a subsequent call.
.RE
.PP
The
.B sc_mlist
structure contains the following members:
.PP
.RS
.nf
\fC\s-1\
struct sc_mlist {
    int major;
    struct module_info mi;
    struct module_stat ms;
};
\s+1\fP
.fi
.TP \w'major\(em'u
.I major
Specifies the
.I major
device number for the driver whose information is contained in this entry.
.TP
.I mi
Contains the
.B module_info
structure associated with the driver with the
.I major
device number specified.
For details of the
.B module_info
structure, see
.BR module_info (9).
.TP
.I ms
Contains the
.B module_stats
structure associated with the driver with the
.I major
device number specified.
For details of the
.B module_stat
structure, see
.BR module_stat (9).
.RE
.\"
.\"
.SH EXAMPLES
.PP
See the source code for
.BR scls (8).
.\"
.\"
.SH MODULES
.PP
.B sc
is a
.I STREAMS
module named
.RI \*(lq sc \*(rq.
.\"
.\"
.SH "SEE ALSO"
.PP
.BR ioctl (2),
.BR nuls (4),
.BR sad (4)),
.BR scls (8),
.BR streamio (7),
.BR autopush (8),
.BR scls (8),
.BR module_info (9),
.BR module_stat (9).
.\"
.\"
.SH BUGS
.PP
The
.B sc
module has no known bugs.
.\"
.\"
.SH COMPATIBILITY
.PP
Many implementations of
.I STREAMS
have some mechanism for augmenting the functionality of the
.BR sad (4)
driver.  Some implementations, such as
.IR AIX \(rg,
.[
aixspg
.]
.IR HP-UX \(rg,
.[
hpuxspg
.]
provide an
.B sc
module for this purpose.
.IP \(em \w'\(em\(em'u
.IR AIX \(rg
.[
aixspg
.]
provides an
.B sc
module for the purpose of allowing
.BR autopush (8)
to use device names instead of major device numbers, and to support the
.BR scls (8)
utility.
.IP \(em
.IR AIX \(rg
.[
aixspg
.]
requires the use of the
.B sc
modules with the
.BR nuls (4)
driver.
.IP \(em
.IR HP-UX \(rg
.[
hpuxspg
.]
describes the
.B sc
module as a core
.I STREAMS
module used by
.BR autopush (8)
and provides support for device names instead of device numbers, and providing
supplemental functions for the
.BR sad (4)
driver.
.IP \(em
.B sc
can be pushed over any stream, unlike the
.IR AIX \(rg
or
.IR HP-UX \(rg
documentation.
The user must have sufficient privilege to push the
.B sc
module.
.IP \(em
Internals of the
.B sc
module is implementation dependent, not subject to standardization, and not
documented.
This manual page documents the
.B "Linux Fast-STREAMS"
implementation of the
.B sc
module.
Compatibility with other implementations is not guaranteed.
.\"
.\"
.SH CONFORMANCE
.PP
None.
.\"
.\"
.SH HISTORY
.PP
An
.B sc
module for extending the capabilities of the
.BR sad (4)
driver appear in
.IR AIX \(rg
.[
aixspg
.]
and
.IR HP-UX \(rg
.[
hpuxspg
.]
documentation.
.\"
.\"
.[
$LIST$
.]
.TI
