'\" rtp
.\" -*- nroff -*- vim: ft=nroff nocin nosi
.\"
.\" @(#) s_fifo.4.man,v 0.9.2.15 2006/04/05 10:05:06 brian Exp
.\"
.\" =========================================================================
.\"
.\" Copyright (c) 2001-2006  OpenSS7 Corporation <http://www.openss7.com/>
.\"
.\" All Rights Reserved.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a
.\" permission notice identical to this one
.\" 
.\" Since the Linux kernel and libraries are constantly changing, this
.\" manual page may be incorrect or out-of-date.  The author(s) assume no
.\" responsibility for errors or omissions, or for damages resulting from
.\" the use of the information contained herein.  The author(s) may not
.\" have taken the same level of care in the production of this manual,
.\" which is licensed free of charge, as they might when working
.\" professionally.  The author(s) will take no responsibility in it.
.\" 
.\" Formatted or processed versions of this manual, if unaccompanied by
.\" the source, must acknowledge the copyright and authors of this work.
.\"
.\" -------------------------------------------------------------------------
.\"
.\" U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software
.\" on behalf of the U.S. Government ("Government"), the following
.\" provisions apply to you.  If the Software is supplied by the Department
.\" of Defense ("DoD"), it is classified as "Commercial Computer Software"
.\" under paragraph 252.227-7014 of the DoD Supplement to the Federal
.\" Acquisition Regulations ("DFARS") (or any successor regulations) and the
.\" Government is acquiring only the license rights granted herein (the
.\" license rights customarily provided to non-Government users).  If the
.\" Software is supplied to any unit or agency of the Government other than
.\" DoD, it is classified as "Restricted Computer Software" and the
.\" Government's rights in the Software are defined in paragraph 52.227-19
.\" of the Federal Acquisition Regulations ("FAR") (or any successor
.\" regulations) or, in the cases of NASA, in paragraph 18.52.227-86 of the
.\" NASA Supplement to the FAR (or any successor regulations).
.\"
.\" =========================================================================
.\" 
.\" Commercial licensing and support of this software is available from
.\" OpenSS7 Corporation at a fee.  See http://www.openss7.com/
.\" 
.\" =========================================================================
.\"
.\" Last Modified 2006/04/05 10:05:06 by brian
.\"
.\" -------------------------------------------------------------------------
.\"
.\" s_fifo.4.man,v
.\" Revision 0.9.2.15  2006/04/05 10:05:06  brian
.\" - get references in right place
.\"
.\" Revision 0.9.2.14  2006/04/05 09:44:39  brian
.\" - moved .so line and updated headers
.\"
.\" =========================================================================
.R1
bracket-label "\fR[\fB" "\fR]" "\fR, \fB"
no-default-database
database strutil.refs
accumulate
move-punctuation
abbreviate A
join-authors ", " ", " " and "
et-al " et al" 2 3
abbreviate-label-ranges ".."
sort-adjacent-labels
.R2
.so strutil.macros
.\"
.\"
.TH S_FIFO 4 "@PACKAGE_DATE@" "@PACKAGE@-@VERSION@" "@PACKAGE_TITLE@ Devices"
.\"
.\"
.SH NAME
.B s_fifo
\- \fISTREAMS\fP-based first-in first-out special file, named pipe
.\"
.\"
.SH SYNOPSIS
.PP
.B #include <sys/types.h>
.br
.B #include <sys/stat.h>
.br
.B #include <fcntl.h>
.\"
.\"
.HP 8
.BI "int " fd " = open(const char *" pathname ", int " flags );
.\"
.\"
.SH DESCRIPTION
.PP
A
.BR FIFO,
(also referred to in the literature as a
.RI \*(lq "named pipe" \*(rq),
is a first-in first-out special node in a file system.
The special node is created in a file system using
.BR mkfifo (3)
or
.BR mkfifo (1).
The node may be opened for reading, writing or both.  Data written
successfully to the
.B FIFO
with a
.BR write (2)
operation will be read by a subsequent
.BR read (2)
operation in a first-in first-out manner.
One
.B FIFO
exists for each
.B FIFO
special node in a file system.
.\"
.\"
.PP
Names pipes
.RB ( FIFO s)
are typically used for interprocess communications in the same circumstances
as a software pipe,
.[
advprog
%P 446
.]
.BR pipe (2),
or
.IR STREAMS (4)-based
software pipe,
.BR s_pipe (3);
however, whereas software pipes are normally created before a call to
.BR fork (2),
.BR FIFO s
can be used to communication between two independent processes, each opening
the named pipe in the file system.
For
.IR STREAMS (4)-based
software pipes, a similar effect can be achieved by naming one end of the pipe
using
.BR fattach (2).
See the
.IR STREAMS (4)-based
software pipe manual page
.BR s_pipe (3)
and the
.BR connld (4)
module for more information.
.\"
.\"
.PP
.IR STREAMS (4)-based
named pipes support blocking or non-blocking operation for readers and
writers.
When a
.B FIFO
is opened read-only or write-only with blocking
.RB ( O_NONBLOCK
flag clear), the
.BR open (2)
call will block until a writer or reader (resp.) opens the given
.BR FIFO .
When a
.B FIFO
is opened read-write with blocking
.RB ( O_NONBLOCK
flag clear), the
.BR open (2)
call will not block and returns with the fifo open.
When a
.B FIFO
is opened read-only or write-only with non-blocking
.RB ( O_NONBLOCK
flag set), the
.BR open (2)
call returns immediately.  In the case where the
.B FIFO
was opened write-only, the
.B FIFO
is not opened, and the
.IR errno (3)
code
.RB [ ENXIO ]
is returned if there is no reader associated with the
.B FIFO
at the time of the
.BR open (2)
system call.
When a
.B FIFO
is opened read-write with non-blocking
.RB ( O_NONBLOCK
flag set), the
.BR open (2)
call returns immediately with the
.B FIFO
open.
.\"
.\"
.PP
If an attempt is made to
.BR seek (2)
on a named pipe, the
.IR errno (3)
.RB [ ESPIPE ]
is returned.
.\"
.\"
.PP
Attempts to
.BR read (2)
from a
.B FIFO
that has no writers will always return zero (0) indicating end of file.  This
is in distinction to
.IR STREAMS (4)-based
pipes (see
.BR s_pipe (3))
that will return
.RB [ ESTRPIPE ].
Attempts to
.BR read (2)
from a
.BR FIFO
that has no data to read when set for non-blocking operation will return
.IR errno (3)
.RB [ EAGAIN ].
When set for blocking operation, the call to
.BR read (2)
will block until data is available for reading, a signal interrupts the system
call, or the last writer closes the
.BR FIFO .
Null
.BR read (2)
will always succeed and return zero (0).
.\"
.\"
.PP
Attempts to
.BR write (2)
to a
.B FIFO
that has no readers result in the
.BR signal (2)
.B SIGPIPE
being sent to the writing process.
Attempts to
.BR write (2)
to a
.B FIFO
that is full when set for non-blocking operation will return
.IR errno (3)
.RB [ EAGAIN ].
Attempts to
.BR write (2)
to a
.B FIFO
that is full when set for blocking operation will block until there is
write space available, a signal interrupts the system call, or the last reader
closes the
.BR FIFO .
When the last reader closes the pipe, current and subsequent
.BR write (2)
attempts will illicit a
.B SIGPIPE
signal and subsequent
.BR write (2)
attempts will return
.IR errno (3)
.RB [ EPIPE ].
Null
.BR write (2)
will always succeed and return zero (0).
.\"
.\"
.PP
When a
.BR read (2)
or
.BR write (2)
operation exits with some data read or written as a result of a caught
.BR signal (2)
the
.BR read (2)
or
.BR write (2)
call will return the amount of data read or written in compliance to the
.B FIPS 151-1
behaviour.
.\"
.\"
.SH EXAMPLES
.PP
.\"
.\"
.SH NOTICES
.PP
Without
.BR "Linux Fast-STREAMS" ,
.[
LfS
.]
.I Linux\(rg
provides a simple POSIX
compliant
SVR 3
.[
svr3
.]
style kernel based
.B FIFO
mechanism.
A limitation of this approach is that
.IR STREAMS (4)
modules cannot be pushed onto the
.BR FIFO .
.\"
.\"
.PP
.B Linux Fast-STREAMS
provides
.I Linux\(rg
with the ability to use
.IR STREAMS (4)
based
.BR FIFO s
in two ways:
.\"
.\"
.IP (1) \w'(000)'u
as a file-system based
.B S_IFIFO
special node, replacing the
SVR 3
.[
svr3
.]
style
.I Linux\(rg
.BR FIFO s
with SVR 4.2
.[
svr42
.]
style
.BR FIFO s.
This is a SVR 4.2 drop-in replacement for the
.I Linux\(rg
SVR 3 style
.BR FIFO s
when the kernel is compiled with
.B CONFIG_STREAMS_FIFOS
defined, and provides the following additional features:
.RS
.\"
.\"
.IP \(em \w'\(em\(em'u
supports
.BR putpmsg (2s)
and
.BR getpmsg (2s)
system calls allowing writing structured messages including control and data
portions into, and reading them from, the
.BR FIFO .
This includes support for priority bands.
.\"
.\"
.IP \(em
supports
.BR streamio (7)
input output controls, including the ability to
.I I_PUSH
modules onto the
.BR FIFO .
All
.BR streamio (7)
input output controls are supported with the exception of
.IR I_LINK ", " I_PLINK ", " I_UNLINK " and " I_PUNLINK .
(Because traditional SVR 4.2
.[
svr42
.]
.IR STREAMS (4)-based
.BR FIFO s
cannot be linked under a multiplexing driver, performing an
.I I_LINK
on a
.B S_IFIFO
based
.B FIFO
is not permitted.)
.\"
.\"
.RE
.\"
.\"
.IP (2) \w'(000)'u
as a file-system based
.B S_IFCHR
special node, in supplement to the
.B S_IFIFO
special node construct.
This is a
.IR STREAMS (4)-based
supplement to regular SVR 4.2
.[
svr42
.]
.BR FIFO s,
providing the following enhanced features:
.RS
.\"
.\"
.IP \(em
supports
.BR putpmsg (2s)
sand
.BR getpmsg (2s)
system calls allowing writing structured messages including control and data
portions into, and reading them from, the
.BR FIFO .
This includes support for priority bands.
.\"
.\"
.IP \(em
supports
.BR streamio (7)
input output controls.  All
.BR streamio (7)
input output controls are supported, including the ability to
.I I_PUSH
modules onto the
.B FIFO
and
.I I_LINK
.BR FIFO s
under a multiplexing driver.
.IR I_LINKing
.BR FIFO s
under a multiplexing driver is useful for testing of
.IR STREAMS (4)
drivers.
.\"
.\"
.RE
.\"
.\"
.PP
The
.B Linux Fast-STREAMS
.[
LfS
.]
implementation of character-based
.BR FIFO s
only consumes a single device number (major/minor combination).  This is
because
.BR FIFO s
are attached to the underlying character device special node in the file system
and are never allocated a normal character-based snode in the specfs.  This is
identical to the mechanism used for fifo special nodes.  This is accomplished
using the
.B LfS
minor device number registration.  (See
.BR register_strdev_minor (9)
and
.BR unregister_strdev_minor (9).)
.\"
.\"
.PP
Allocation of major and minor device numbers is, however, an issue for
.BR LiS ,
.[
LiS
.]
which uses an inferior mechanism.
.B LfS
.[
LfS
.]
does not have this limitation.
.\"
.\"
.SH CAVEATS
.PP
Fifo special node file-system based named pipes will only use
.IR STREAMS (4)-based
named pipes if the
.I Linux\(rg
kernel has been compiled with
.B CONFIG_STREAMS_FIFOS
set.  Otherwise, the normal SVR 3
.[
svr3
.]
based
.I Linux\(rg
.BR FIFO s
will be used.  Fifo special node file-system based
.BR FIFOs
will always appear in the output of
.BR ls (1)
or
.BR stat "(2), " lstat "(2) or " fstat (2)
as a
.BR FIFO .
.\"
.\"
.PP
Character special node
file-system based
.BR FIFO s
will appear in the output of
.BR ls (1)
or
.BR stat "(2), " lstat "(2) or " fstat (2)
as a character device node with the major and minor device number of the
.IR STREAMS (4)-based
.BR FIFO
pseudo-device.
Whenever
.IR STREAMS (4)
is included in the
.I Linux\(rg
kernel, the
.IR STREAMS (4)-based
character special node named pipes will still be available.
.\"
.\"
.SH DEVICES
.PP
.TP
.B /dev/s_fifo
The external filesystem
.I STREAMS
fifo device.
.TP
.BR /dev/streams/s_fifo ", " /devices/s_fifo
The
.BR specfs (5)
shadow special filesystem
.I STREAMS
fifo device.
.\"
.\"
.SH "SEE ALSO"
.PP
.IR STREAMS (4),
.BR mkfifo (3),
.BR mkfifo (1),
.BR write (2),
.BR read (2),
.BR pipe (2),
.BR s_pipe (3),
.BR putpmsg (2s),
.BR getpmsg (2s),
.BR streamio (7),
.BR ls (1),
.BR socketpair (2),
.BR open (2),
.BR stat (2),
.BR lstat (2),
.BR fstat (2),
.BR signal (2),
.BR sigaction (2),
.BR register_strdev_minor (9),
.BR unregister_strdev_minor (9).
.\"
.\"
.SH BUGS
.PP
This
.B Linux Fast-STREAMS
implementation has no known bugs.
.\"
.\"
.SH "CONFORMING TO"
.PP
SVID,
.[
svid
.]
SVR3,
.[
svr3
.]
SVR4,
.[
svr4
.]
SVR4.2,
.[
svr42
.]
X/Open,
.[
xbd
.]
POSIX,
FIPS 151-1.
.\"
.\"
.SH HISTORY
UNIX\(rg\ System V Release 3 (SVR3)
.[
svr3
.]
had a
.B FIFO
file-system construct; however, this construct was not streams based.
.I Linux\(rg
without
.B Linux Fast-STREAMS
enabled operates in the fashion of SVR3.
UNIX\(rg\ System V Release 4 (SVR4)
.[
svr4
.]
introduced the
.IR STREAMS (4)
implementation of the
.BR FIFO .
.I Linux\(rg
with
.B Linux-Fast STREAMS
enabled
.RB ( CONFIG_STREAMS " or " CONFIG_STREAMS_MODULE " defined)"
and
.IR STREAMS (4)-based
.BR FIFO s
enabled
.RB ( CONFIG_STREAMS_FIFOS " defined)"
will used the
.IR STREAMS (4)-based
.B FIFO
mechanism ala SVR4 and SVR4.2.
.[
svr42
.]
.\"
.\"
.[
$LIST$
.]
.TI

