'\" rtp
.\" -*- nroff -*- vim: ft=nroff nocin nosi
.\"
.\" @(#) nuls.4.man,v 0.9.2.15 2006/04/05 09:44:39 brian Exp
.\"
.\" =========================================================================
.\"
.\" Copyright (c) 2001-2006  OpenSS7 Corporation <http://www.openss7.com/>
.\"
.\" All Rights Reserved.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a
.\" permission notice identical to this one
.\" 
.\" Since the Linux kernel and libraries are constantly changing, this
.\" manual page may be incorrect or out-of-date.  The author(s) assume no
.\" responsibility for errors or omissions, or for damages resulting from
.\" the use of the information contained herein.  The author(s) may not
.\" have taken the same level of care in the production of this manual,
.\" which is licensed free of charge, as they might when working
.\" professionally.  The author(s) will take no responsibility in it.
.\" 
.\" Formatted or processed versions of this manual, if unaccompanied by
.\" the source, must acknowledge the copyright and authors of this work.
.\"
.\" -------------------------------------------------------------------------
.\"
.\" U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software
.\" on behalf of the U.S. Government ("Government"), the following
.\" provisions apply to you.  If the Software is supplied by the Department
.\" of Defense ("DoD"), it is classified as "Commercial Computer Software"
.\" under paragraph 252.227-7014 of the DoD Supplement to the Federal
.\" Acquisition Regulations ("DFARS") (or any successor regulations) and the
.\" Government is acquiring only the license rights granted herein (the
.\" license rights customarily provided to non-Government users).  If the
.\" Software is supplied to any unit or agency of the Government other than
.\" DoD, it is classified as "Restricted Computer Software" and the
.\" Government's rights in the Software are defined in paragraph 52.227-19
.\" of the Federal Acquisition Regulations ("FAR") (or any successor
.\" regulations) or, in the cases of NASA, in paragraph 18.52.227-86 of the
.\" NASA Supplement to the FAR (or any successor regulations).
.\"
.\" =========================================================================
.\" 
.\" Commercial licensing and support of this software is available from
.\" OpenSS7 Corporation at a fee.  See http://www.openss7.com/
.\" 
.\" =========================================================================
.\"
.\" Last Modified 2006/04/05 09:44:39 by brian
.\"
.\" -------------------------------------------------------------------------
.\"
.\" nuls.4.man,v
.\" Revision 0.9.2.15  2006/04/05 09:44:39  brian
.\" - moved .so line and updated headers
.\"
.\" =========================================================================
.R1
bracket-label "\fR[\fB" "\fR]" "\fR, \fB"
no-default-database
database strutil.refs
accumulate
move-punctuation
abbreviate A
join-authors ", " ", " " and "
et-al " et al" 2 3
abbreviate-label-ranges ".."
sort-adjacent-labels
.R2
.so strutil.macros
.\"
.\"
.TH NULS 4 "@PACKAGE_DATE@" "@PACKAGE@-@VERSION@" "@PACKAGE_TITLE@ Devices"
.\"
.\"
.SH NAME
.B nuls
\- null \fISTREAMS\fR device
.\"
.\"
.SH SYNOPSIS
.PP
.B #include <unistd.h>
.br
.B #include <stropts.h>
.HP 12
.BI "int " fd " = open(" /dev/nuls ", " oflag );
.\"
.\"
.SH DESCRIPTION
.PP
.I fd
is a file descriptor for a null stream opened using the
.BR open (2)
system call on one of the following devices:
.TP
.RB \*(lq /dev/nuls \*(rq
This device is accessible to all users.
.PP
The
.B nuls
device is characterized by the following behaviour:
.IP \(em \w'\(em\(em'u
All data written to  the
.B nuls
device with
.BR write (2),
.BR writev (2),
.BR putmsg (2)
and
.BR putpmsg (2s)
is discarded.
.IP \(em
All attempts to read the
.B nuls
device with
.BR read (2),
.BR readv (2),
.BR getmsg (2)
or
.BR getpmsg (2s)
will return zero length data.
.PP
In contrast to the Linux
.B /dev/null
and
.B /dev/zero
(see
.BR null (4),
.BR zero (4)),
.B nuls
is a
.B STREAMS
null device with the following additional characteristics:
.IP \(em \w'\(em\(em'u
.I STREAMS
modules can be pushed and popped from the device.
.IP \(em
The device response to all
.I STREAMS
I/O controls described in
.BR streamio (7).
.IP \(em
The device can be linked under a multiplexing driver.
.\"
.\"
.SH IOCTLS
.PP
.B nuls
does not support any I/O controls of its own and all I/O controls delivered to
the driver will return an
.IR errno (3)
of
.RB [ EOPNOTSUPP ].
.\"
.\"
.SH USAGE
.PP
The
.B nuls
device can be opened when no other suitable device exists and modules may be
pushed on the
.B nuls
device.
.PP
Pushing a
.I STREAMS
module that responds to administrative I/O controls on the
.B nuls
device is a method of providing administrative drivers without consuming major device
numbers.
.\"
.\"
.SH NOTICES
.PP
The
.B nuls
device is used on systems that provide the older
.IR "SVR 3"
.[
svr3
.]
style
.B /dev/null
or
.BR /dev/zero .
On those systems, the
.B /dev/null
and
.B /dev/zero
devices are not
.I STREAMS
based and will not respond to
.I STREAMS
I/O controls.
.PP
The
.B nuls
device is used with the
.BR sc (4)
module as on
.IR AIX \(rg,
.IR HP-UX \(rg,
and
.IR OSF/1 \(rg
systems in support of the
.BR autopush (8),
.BR scls (8),
.BR strinfo (8),
.BR strload (8),
and
.BR strsetup (8)
commands.
.PP
Under
.B Linux Fast-STREAMS
.[
lfs
.]
the
.B nuls
device is also used with the
.BR sockmod (4)
module in support of
.BR libsocket ,
and by
.BR libstreams ,
as an anonymous stream for non-file-descriptor related system call emulation
for
.BR fdetach (3).
.\"
.\"
.SH IMPLEMENTATION
.PP
.B nuls
is implemented as a regular
.I STREAMS
pseudo-device driver.
.\"
.\"
.\".SH EXAMPLES
.\".PP
.\"
.\"
.SH DEVICES
.PP
.TP
.B /dev/nuls
The external filesystem null
.I STREAMS
device.
.TP
.BR /dev/streams/nuls ", " /devices/nuls
The
.BR specfs (5)
shadow special filesystem null
.I STREAMS
device.
.\"
.\"
.SH "SEE ALSO"
.PP
.BR null (4),
.BR zero (4),
.BR echo (4),
.\"
.\"
.SH BUGS
.PP
.B nuls
has no known bugs.
.\"
.\"
.SH COMPATIBILITY
.PP
The
.B nuls
device is compatible with
.IR "SVR 4.2" ,
.IR AIX \(rg,
.IR HP-UX \(rg,
and
.IR OSF/1 \(rg
with the following portability considerations:
.IP \(em \w'\(em\(em'u
.B /dev/nuls
can be used instead of
.B /dev/null
or
.B /dev/zero
for any purpose for which those devices are used.
.\"
.\"
.SH CONFORMANCE
.PP
.IR "SVR 4.2" ,
.[
svr42cr
.]
and
.IR AIX \(rg,
.IR HP-UX \(rg,
and
.IR OSF/1 \(rg
documentation.
.[
aixdoc
.]
.[
hpuxdoc
.]
.[
osfdoc
.]
.\"
.\"
.SH HISTORY
.PP
The
.B nuls
device first appeared in
.I SVR 4.2
.[
svr42
.]
implementations for
.IR AIX \(rg,
.IR HP-UX \(rg,
and
.IR OSF/1 \(rg.

.\"
.\"
.[
$LIST$
.]
.TI
