'\" rtp
.\" -*- nroff -*- vim: ft=nroff nocin nosi
.\"
.\" @(#) connld.4.man,v 0.9.2.10 2006/04/05 09:44:39 brian Exp
.\"
.\" =========================================================================
.\"
.\" Copyright (c) 2001-2006  OpenSS7 Corporation <http://www.openss7.com/>
.\"
.\" All Rights Reserved.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a
.\" permission notice identical to this one
.\" 
.\" Since the Linux kernel and libraries are constantly changing, this
.\" manual page may be incorrect or out-of-date.  The author(s) assume no
.\" responsibility for errors or omissions, or for damages resulting from
.\" the use of the information contained herein.  The author(s) may not
.\" have taken the same level of care in the production of this manual,
.\" which is licensed free of charge, as they might when working
.\" professionally.  The author(s) will take no responsibility in it.
.\" 
.\" Formatted or processed versions of this manual, if unaccompanied by
.\" the source, must acknowledge the copyright and authors of this work.
.\"
.\" -------------------------------------------------------------------------
.\"
.\" U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software
.\" on behalf of the U.S. Government ("Government"), the following
.\" provisions apply to you.  If the Software is supplied by the Department
.\" of Defense ("DoD"), it is classified as "Commercial Computer Software"
.\" under paragraph 252.227-7014 of the DoD Supplement to the Federal
.\" Acquisition Regulations ("DFARS") (or any successor regulations) and the
.\" Government is acquiring only the license rights granted herein (the
.\" license rights customarily provided to non-Government users).  If the
.\" Software is supplied to any unit or agency of the Government other than
.\" DoD, it is classified as "Restricted Computer Software" and the
.\" Government's rights in the Software are defined in paragraph 52.227-19
.\" of the Federal Acquisition Regulations ("FAR") (or any successor
.\" regulations) or, in the cases of NASA, in paragraph 18.52.227-86 of the
.\" NASA Supplement to the FAR (or any successor regulations).
.\"
.\" =========================================================================
.\" 
.\" Commercial licensing and support of this software is available from
.\" OpenSS7 Corporation at a fee.  See http://www.openss7.com/
.\" 
.\" =========================================================================
.\"
.\" Last Modified 2006/04/05 09:44:39 by brian
.\"
.\" -------------------------------------------------------------------------
.\"
.\" connld.4.man,v
.\" Revision 0.9.2.10  2006/04/05 09:44:39  brian
.\" - moved .so line and updated headers
.\"
.\" =========================================================================
.R1
bracket-label "\fR[\fB" "\fR]" "\fR, \fB"
no-default-database
database strutil.refs
accumulate
move-punctuation
abbreviate A
join-authors ", " ", " " and "
et-al " et al" 2 3
abbreviate-label-ranges ".."
sort-adjacent-labels
.R2
.so strutil.macros
.\"
.\"
.TH CONNLD 4 "@PACKAGE_DATE@" "@PACKAGE@-@VERSION@" "@PACKAGE_TITLE@ Devices"
.\"
.\"
.SH NAME
.B connld
\- incomplete man page
.\"
.\"
.SH SYNOPSIS
.PP
.HP 12
.BI "int " pfds[2] ;
.HP 12
.BI "int s_pipe(" pfds );
.HP 12
.BI "int ioctl(" pfds[0] ", " I_PUSH ", " \*(lqconnld\*(rq );
.HP 12
.BI "int fattach(" pfds[0] ", " \*(lq/tmp/server\*(rq );
.HP 12
.BI "int ioctl(" pfds[1] ", " I_RECVFD ", struct strfdinsert *" fdi );
.\"
.\"
.SH DESCRIPTION
.PP
.B connld
is a
.I STREAMS
module that can be pushed over a
.IR STREAMS -based
bi-drectional software pipe (see
.BR spx (4))
to provide automatic generation of new
.IR STREAMS -based
bi-drectional software pipes between a client and server process.
.PP
When
.BR open (2)
is called on the end of a pipe upon which
.B connld
has been pushed (see
.BR streamio (7))
a new software pipe is created.  The file descriptor for the far end of the
newly created pipe is sent to the other end of the existing pipe in the same
fashion as an
.I I_SENDFD
IO control (see
.BR streamio (7))
and can be received at the other end of the existing pipe with
.IR I_RECVFD .
The file descriptor returned by the
.BR open (2)
call will be the near end of the newly created pipe.
.\"
.\"
.SH USAGE
.PP
The normal usage of
.B connld
is as follows:
.IP (1) \w'(000)'u
A server process creates a software pipe using
.BR pipe (2)
or
.BR spx (4).
.IP (2)
The server process pushes the
.B connld
module on the client end of the pipe using the
.I I_PUSH
command of
.BR streamio (7).
.IP (3)
The server process names the client end of the pipe using
.BR fattach (3).
.IP (4)
The server process uses
.BR poll (2)
to listen for received file descriptors on the server end of the pipe.
.IP (5)
When a client process performs an
.BR open (2)
on the file to which the client end of the pipe has been named with
.BR fattach (3),
.B connld
creates a new pipe, sends the server side file descriptor to the server with
the
.I I_SENDFD
command of
.BR streamio (7)
and returns the file descriptor of the client end of the new pipe in return to
the
.BR open (2)
call.
.IP (6)
The server receives the file descriptor with the
.I I_RECVFD
command of
.BR streamio (7)
resulting in a unique per-client bi-directional
.IR STREAMS -based
pipe for each connecting client.
.\"
.\"
.SH EXAMPLES
.PP
A description and a client-server example for the
.B connld
module appears in
.IR "\*(lqAdvanced Programming in the UNIX\(rg Environment\*(rq" .
.[
advprog
%P 498
.]
.\"
.\"
.SH MODULES
.PP
.B connld
is a
.I STREAMS
module named
.IR \*(lqconnld\*(rq .
.\"
.\"
.SH "SEE ALSO"
.PP
.BR spx (4)),
.BR open (2),
.BR streamio (7),
.BR fattach (3),
.BR poll (2).
.\"
.\"
.SH BUGS
.PP
.B connld
has no known bugs.
.\"
.\"
.SH COMPATIBILITY
.PP
.B connld
is compatible with
.IR Solaris \(rg,
.IR UnixWare \(rg
.BR SVR 4.2
.[
svr42
.]
and
.BR LiS .
.[
LiS
.]
.\"
.\"
.SH CONFORMANCE
.PP
SVR 4.2,
.[
svr42
.]
SVID,
.[
svid
.]
XID,
.[
xbd5
.]
SUSv2,
.[
susv2
.]
SUSv3.
.[
susv3
.]
.\"
.\"
.SH HISTORY
.PP
.B connld
first appeared in SVR 4.
.[
svr4
.]
.\"
.\"
.[
$LIST$
.]
.TI
