'\" rtp
.\" -*- nroff -*- vim: ft=nroff nocin nosi
.\"
.\" @(#) pipe.3.man,v 0.9.2.14 2006/04/05 09:44:38 brian Exp
.\"
.\" =========================================================================
.\"
.\" Copyright (c) 2001-2006  OpenSS7 Corporation <http://www.openss7.com/>
.\"
.\" All Rights Reserved.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a
.\" permission notice identical to this one
.\" 
.\" Since the Linux kernel and libraries are constantly changing, this
.\" manual page may be incorrect or out-of-date.  The author(s) assume no
.\" responsibility for errors or omissions, or for damages resulting from
.\" the use of the information contained herein.  The author(s) may not
.\" have taken the same level of care in the production of this manual,
.\" which is licensed free of charge, as they might when working
.\" professionally.  The author(s) will take no responsibility in it.
.\" 
.\" Formatted or processed versions of this manual, if unaccompanied by
.\" the source, must acknowledge the copyright and authors of this work.
.\"
.\" -------------------------------------------------------------------------
.\"
.\" U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software
.\" on behalf of the U.S. Government ("Government"), the following
.\" provisions apply to you.  If the Software is supplied by the Department
.\" of Defense ("DoD"), it is classified as "Commercial Computer Software"
.\" under paragraph 252.227-7014 of the DoD Supplement to the Federal
.\" Acquisition Regulations ("DFARS") (or any successor regulations) and the
.\" Government is acquiring only the license rights granted herein (the
.\" license rights customarily provided to non-Government users).  If the
.\" Software is supplied to any unit or agency of the Government other than
.\" DoD, it is classified as "Restricted Computer Software" and the
.\" Government's rights in the Software are defined in paragraph 52.227-19
.\" of the Federal Acquisition Regulations ("FAR") (or any successor
.\" regulations) or, in the cases of NASA, in paragraph 18.52.227-86 of the
.\" NASA Supplement to the FAR (or any successor regulations).
.\"
.\" =========================================================================
.\" 
.\" Commercial licensing and support of this software is available from
.\" OpenSS7 Corporation at a fee.  See http://www.openss7.com/
.\" 
.\" =========================================================================
.\"
.\" Last Modified 2006/04/05 09:44:38 by brian
.\"
.\" -------------------------------------------------------------------------
.\"
.\" pipe.3.man,v
.\" Revision 0.9.2.14  2006/04/05 09:44:38  brian
.\" - moved .so line and updated headers
.\"
.\" =========================================================================
.R1
bracket-label "\fR[\fB" "\fR]" "\fR, \fB"
no-default-database
database strutil.refs
accumulate
move-punctuation
abbreviate A
join-authors ", " ", " " and "
et-al " et al" 2 3
abbreviate-label-ranges ".."
sort-adjacent-labels
.R2
.so strutil.macros
.\" =========================================================================
.\"
.\" Copyright (C) 2000  John A. Boyd Jr.  protologos, LLC
.\"
.\" This library is free software; you can redistribute it and/or
.\" modify it under the terms of the GNU Library General Public
.\" License as published by the Free Software Foundation; either
.\" version 2 of the License, or (at your option) any later version.
.\"
.\" This library is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
.\" Library General Public License for more details.
.\"
.\" You should have received a copy of the GNU Library General Public
.\" License along with this library; if not, write to the
.\" Free Software Foundation, Inc., 59 Temple Place - Suite 330, Cambridge,
.\" MA 02139, USA.
.\"
.\" =========================================================================
.\"
.\"
.TH PIPE 2 "@PACKAGE_DATE@" "@PACKAGE@-@VERSION@" "@PACKAGE_TITLE@ Library Calls"
.\"
.\"
.SH NAME
.B pipe
\- create a \fISTREAMS\fR \fIpipe\fR
.\"
.\"
.SH SYNOPSIS
.PP
.B #include <unistd.h>
.HP
.BI int pipe( int " filedes "[2] );
.\"
.\"
.SH ARGUMENTS
.PP
.TP
.I filedes
An pointer to two integer file descriptors into which to return the file
descriptor for each end of the pipe.
.\"
.\"
.SH DESCRIPTION
.PP
.BR pipe ()
creates a
.BR STREAMS
.I pipe
(see
.BR fifo (4)
and
.BR STREAMS (4)),
and provides access to its ends as a pair of file descriptors
returned in the
.I filedes
argument.
.sp
The file descriptors returned allow both read and write access
to the pipe.  Data written to one end is readable at the other,
independently in each direction;  i.e.,
.I STREAMS
pipes are not just
.IR bidirectional ,
but
.IR full-duplex .
.sp
Structurally, a
.I STREAMS
.I pipe
consists of a pair of
.IR "stream heads" ,
each comprising a read/write queue pair, with the write queue of each
end directed to the read queue of the other end.
The point at which this occurs is referred to as the
.I midpoint
of the pipe.
.sp
Generally otherwise, a
.I STREAMS
.I pipe
behaves as a pair of
.I STREAMS
files; e.g.,
.I STREAMS
.I modules
may be pushed onto either end, etc..
.sp
A notable exception is that
.I STREAMS
.I pipes
provide the (only) means for passing open file descriptors via the
.I STREAMS
.B I_SENDFD
and
.B I_RECVFD
.I ioctl
mechanisms.  Specifically, a file descriptor can (and must) be sent
on one end of a pipe via
.B I_SENDFD
to the other end, where it may be received via
.BR I_RECVFD .
.\"
.\"
.SH "RETURN VALUE"
.PP
Upon successful completion,
.BR pipe ()
returns 0.
.\"
.\"
.SH ERRORS
.PP
Upon failure,
.BR pipe ()
returns -1, and
.BR errno (3)
is set to indicate the error causing the failure.
.\"
.\"
.SH "APPLICATION USAGE"
.PP
The Linux kernel provides an independent implementation of
.IR pipes ,
corresponding to that provided before SVR4
.[
svr4
.]
used
.I STREAMS
to implement them (see 
.BR pipe (2)).
Although the interface is identical, the two are quite different
otherwise.
.I STREAMS
provide significant additional capability, but possibly at a lower
level of performance.
Notably,
.I STREAMS
pipes are full duplex (i.e., both ends support both read and write
access independently), and allow the use of
.I STREAMS
.I modules
to augment the processing of data.  Moreover, such processing may
be
.IR message \- oriented :
message boundaries may be established and respected by using the
.BR getmsg (2)/ getpmsg (2s)
and
.BR putmsg (2)/ putpmsg (2s)
primitives instead of
.BR read (2)
and
.BR write (2).
.SH NOTICES
.PP
Applications wishing to use the
.I STREAMS
version of the
.I pipe
function must link with the
.B LiS
.[
LiS
.]
library which provides it; otherwise,
the Linux kernel version will be used via the Linux/GNU C library.
.\"
.\"
.SH "FUTURE DIRECTIONS"
.PP
Under Linux,
.BR pipe ()
is implemented as an
.I ioctl
operation on an anonymous
.I STREAMS
file.
An alternative system call implementation may be used in the future,
and is fact already supported within
.B LiS\c
.
.[
LiS
.]
.sp
It should be noted that no attention has yet been given to the issue
of atomic reads and writes in
.I STREAMS
pipes and fifos, common to most
implementations of these mechanisms.  This issue will be addressed
hopefully in the near future.
.\"
.\"
.SH "SEE ALSO"
.PP
.BR pipemod (4),
.BR connld (4),
.BR errno (3),
.BR fifo (4),
.BR STREAMS (4).
.\"
.\"
.SH COMPATIBILITY
.PP
.\"
.\"
.SH CONFORMANCE
.PP
.\"
.\"
.SH HISTORY
.PP
UNIX\(rg\ System V Release 4 (SVR4)
.[
svr4
.]
.\"
.\"
.SH AUTHOR
.PP
John Boyd, protologos LLC.
.[
$LIST$
.]
.T3
