'\" rtp
.\" -*- nroff -*- vim: ft=nroff nocin nosi
.\"
.\" @(#) strreset.1.man,v 0.9.2.11 2006/04/05 09:44:37 brian Exp
.\"
.\" =========================================================================
.\"
.\" Copyright (c) 2001-2006  OpenSS7 Corporation <http://www.openss7.com/>
.\"
.\" All Rights Reserved.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of this
.\" manual under the conditions for verbatim copying, provided that the
.\" entire resulting derived work is distributed under the terms of a
.\" permission notice identical to this one
.\" 
.\" Since the Linux kernel and libraries are constantly changing, this
.\" manual page may be incorrect or out-of-date.  The author(s) assume no
.\" responsibility for errors or omissions, or for damages resulting from
.\" the use of the information contained herein.  The author(s) may not
.\" have taken the same level of care in the production of this manual,
.\" which is licensed free of charge, as they might when working
.\" professionally.  The author(s) will take no responsibility in it.
.\" 
.\" Formatted or processed versions of this manual, if unaccompanied by
.\" the source, must acknowledge the copyright and authors of this work.
.\"
.\" -------------------------------------------------------------------------
.\"
.\" U.S. GOVERNMENT RESTRICTED RIGHTS.  If you are licensing this Software
.\" on behalf of the U.S. Government ("Government"), the following
.\" provisions apply to you.  If the Software is supplied by the Department
.\" of Defense ("DoD"), it is classified as "Commercial Computer Software"
.\" under paragraph 252.227-7014 of the DoD Supplement to the Federal
.\" Acquisition Regulations ("DFARS") (or any successor regulations) and the
.\" Government is acquiring only the license rights granted herein (the
.\" license rights customarily provided to non-Government users).  If the
.\" Software is supplied to any unit or agency of the Government other than
.\" DoD, it is classified as "Restricted Computer Software" and the
.\" Government's rights in the Software are defined in paragraph 52.227-19
.\" of the Federal Acquisition Regulations ("FAR") (or any successor
.\" regulations) or, in the cases of NASA, in paragraph 18.52.227-86 of the
.\" NASA Supplement to the FAR (or any successor regulations).
.\"
.\" =========================================================================
.\" 
.\" Commercial licensing and support of this software is available from
.\" OpenSS7 Corporation at a fee.  See http://www.openss7.com/
.\" 
.\" =========================================================================
.\"
.\" Last Modified 2006/04/05 09:44:37 by brian
.\"
.\" -------------------------------------------------------------------------
.\"
.\" strreset.1.man,v
.\" Revision 0.9.2.11  2006/04/05 09:44:37  brian
.\" - moved .so line and updated headers
.\"
.\" =========================================================================
.R1
bracket-label "\fR[\fB" "\fR]" "\fR, \fB"
no-default-database
database strutil.refs
accumulate
move-punctuation
abbreviate A
join-authors ", " ", " " and "
et-al " et al" 2 3
abbreviate-label-ranges ".."
sort-adjacent-labels
.R2
.so strutil.macros
.\"
.\"
.TH STRRESET 1 "@PACKAGE_DATE@" "@PACKAGE@-@VERSION@" "@PACKAGE_TITLE@ User Commands"
.\"
.\"
.SH NAME
.B strreset
\- resets a stream
.\"
.\"
.SH SYNOPSIS
.PP
.HP 12
\fBstrreset\fR [\fIoptions\fR] [ \fB-M\fI major \fR] [ \fB-m\fI minor \fR]
.PD 0
.HP 12
\fBstrreset\fR {\fB-h\fR|\fB--help\fR}
.HP 12
\fBstrreset\fR {\fB-V\fR|\fB--version\fR}
.HP 12
\fBstrreset\fR {\fB-C\fR|\fB--copying\fR}
.PD
.\"
.\"
.SH DESCRIPTION
.PP
The
.B strreset
command resets an open stream by generating a
.BR M_FLUSH (9)
message to the stream head.  You use it mainly to reset blocked streams.  When
it is impossible to reopen the stream, issue an
.B I_FLUSH
.BR streamio (7)
.BR ioctl (2),
or equivalent command.  This situation may happen with a process sleeping in a
module's close routine, when signals can not be sent to the process (a zombie
process exiting, for example).
.\"
.\"
.SH OPTIONS
.PP
.TP
\fR[\fB-M\fR, \fB--major\fR \fImajor\fR]
Specifies the major device number for the special file associated with the
stream to be reset.
.TP
\fR[\fB-m\fR, \fB--minor\fR \fIminor\fR]
Specifies the minor device number for the special file associated with the
stream to be reset.
.PP
The following options are non-portable:
.TP
\fB-d\fR, \fB--debug\fR [\fIlevel\fR]
Increases or sets debugging verbosity, typically for debugging purposes.
.TP
\fB-v\fR, \fB--verbose\fR [\fIlevel\fR]
Increases or sets output verbosity, typically for diagnostic purposes.
.TP
\fB-q\fR, \fB--quiet\fR
Suppresses normal output.
.TP
\fB-h\fR, \fB--help\fR
When this option is encountered,
.B strreset
displays usage information on
.I stdout
and exits.
.TP
\fB-V\fR, \fB--version\fR
When this option is encountered,
.B strreset
displays version information on
.I stdout
and exits.
.TP
\fB-C\fR, \fB--copying\fR
When this option is encountered,
.B strreset
displays copyright and copying information on
.I stdout
and exits.
.\"
.\"
.SH DIAGNOSTICS
.PP
On successful completion the
.B strreset
command returns a value of zero (0).
Otherwise, it returns a non-zero value and prints a diagnostic error message.
.\"
.\"
.\".SH NOTICES
.\".PP
.\"
.\"
.\".SH EXAMPLES
.\".PP
.\"
.\"
.\".SH DEVICES
.\".PP
.\"
.\"
.SH FILES
.PP
.TP
.B /usr/bin/strreset
contains the
.B strreset
command.
.\"
.\"
.SH "SEE ALSO"
.PP
.BR strchg (1),
.BR strconf (1).
.\"
.\"
.SH BUGS
.PP
.B strreset
has no known bugs.
.\"
.\"
.SH COMPATIBILITY
.PP
.IR "SVR 4.2" ,
.IR AIX \(rg,
.IR HP-UX \(rg,
.IR OSF/1 \(rg,
.IR Solaris \(rg,
.IR SUPER-UX \(rg,
.IR UnixWare \(rg
and
.IR UXP/V \(rg,
with the following portability considerations:
.IP \(em
.I SVR 4.2
does not document long options.
The use of long options should be avoided by portable programs.
.IP \(em
Options
.BR --help " and " --version
are provided for compatibility with GNU coding standards;
.BR --copying ", " --debug ", " --verbose " and " --quiet ,
OpenSS7 coding standards.
.\"
.\"
.SH CONFORMANCE
.PP
.IR "SVR 4.2" ;
.[
svr42cr
.]
.IR AIX \(rg,
.IR HP-UX \(rg,
.IR OSF/1 \(rg,
.IR Solaris \(rg,
.IR SUPER-UX \(rg,
.IR UnixWare \(rg,
and
.IR UXP/V \(rg
documentation.
.\"
.\"
.SH HISTORY
.PP
.B strconf
first appeared in
.IR "SVR 4" .
.[
svr4
.]
.\"
.\"
.[
$LIST$
.]
.TI
